/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.List;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Geodesic;
import org.jmol.util.Measure;
import org.jmol.util.TempArray;

public class MeshSurface {
    protected static final int SEED_COUNT = 25;
    public V3[] spanningVectors;
    public String meshType;
    public int vertexCount;
    public P3[] vertices;
    public float[] vertexValues;
    public int[] vertexSource;
    public int polygonCount;
    public int[][] polygonIndexes;
    public float[] polygonTranslucencies;
    public boolean isTriangleSet;
    public boolean haveQuads;
    public short colix;
    public short colixBack;
    public boolean isColorSolid = true;
    public P3 offset;
    public T3[] altVertices;
    public short[] polygonColixes;
    public short[] vertexColixes;
    public T3[] normals;
    public V3[] normalsTemp;
    public int normalCount;
    public int normixCount;
    public BS bsPolygons;
    public M4 mat4;
    public BS[] surfaceSet;
    public int[] vertexSets;
    public int nSets = 0;
    private int checkCount = 2;
    private int lastColor;
    private short lastColix;
    protected int iA;
    protected int iB;
    protected int iC;
    public int polygonCount0;
    public int vertexCount0;
    public BS bsSlabDisplay;
    public BS bsSlabGhost;
    public BS bsTransPolygons;
    public int slabMeshType;
    public short slabColix;
    public BS bsDisplay;
    public SB slabOptions;
    private boolean doClear;
    private boolean doGhost;
    private boolean doCap;
    private int iD;
    private int iE;
    public int mergeVertexCount0;
    public int mergePolygonCount0;
    public boolean isMerged;

    public static MeshSurface newMesh(boolean bl, T3[] t3Array, int n, int[][] nArray, T3[] t3Array2, int n2) {
        MeshSurface meshSurface = new MeshSurface();
        meshSurface.polygonIndexes = nArray;
        if (bl) {
            meshSurface.altVertices = t3Array;
        } else {
            meshSurface.vertices = (P3[])t3Array;
        }
        meshSurface.vertexCount = n == 0 ? t3Array.length : n;
        meshSurface.normals = t3Array2;
        meshSurface.normalCount = n2 == 0 && t3Array2 != null ? t3Array2.length : n2;
        return meshSurface;
    }

    public static MeshSurface newSlab(P3[] p3Array, int n, float[] fArray, int[][] nArray, int n2, int n3) {
        MeshSurface meshSurface = new MeshSurface();
        meshSurface.vertices = p3Array;
        meshSurface.vertexValues = fArray;
        meshSurface.vertexCount = n;
        meshSurface.polygonIndexes = nArray;
        meshSurface.polygonCount = n2;
        meshSurface.checkCount = n3;
        return meshSurface;
    }

    public T3[] getVertices() {
        return this.altVertices == null ? this.vertices : this.altVertices;
    }

    public int[][] getFaces() {
        return this.polygonIndexes;
    }

    public void setColix(short s) {
        this.colix = s;
    }

    public void setColixBack(short s) {
        this.colixBack = s;
    }

    public int addV(P3 p3) {
        if (this.vertexCount == 0) {
            this.vertices = new P3[25];
        } else if (this.vertexCount == this.vertices.length) {
            this.vertices = (P3[])AU.doubleLength(this.vertices);
        }
        this.vertices[this.vertexCount] = P3.newP(p3);
        return this.vertexCount++;
    }

    public void addTriangle(int n, int n2, int n3) {
        this.addPolygon(new int[]{n, n2, n3}, null);
    }

    public void addQuad(int n, int n2, int n3, int n4) {
        this.haveQuads = true;
        this.addPolygon(new int[]{n, n2, n3, n4}, null);
    }

    public void setPolygonCount(int n) {
        this.polygonCount = n;
        if (n < 0) {
            return;
        }
        if (this.polygonIndexes == null || n > this.polygonIndexes.length) {
            this.polygonIndexes = AU.newInt2(n);
        }
    }

    public int addVCVal(P3 p3, float f) {
        if (this.vertexCount == 0) {
            this.vertexValues = new float[25];
        } else if (this.vertexCount >= this.vertexValues.length) {
            this.vertexValues = AU.doubleLengthF(this.vertexValues);
        }
        this.vertexValues[this.vertexCount] = f;
        return this.addV(p3);
    }

    public int addTriangleCheck(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.vertices == null || this.vertexValues != null && (Float.isNaN(this.vertexValues[n]) || Float.isNaN(this.vertexValues[n2]) || Float.isNaN(this.vertexValues[n3])) || Float.isNaN(this.vertices[n].x) || Float.isNaN(this.vertices[n2].x) || Float.isNaN(this.vertices[n3].x) ? -1 : this.addPolygonV3(n, n2, n3, n4, n5, n6, null);
    }

    private int addPolygonV3(int n, int n2, int n3, int n4, int n5, int n6, BS bS) {
        return this.checkCount == 2 ? this.addPolygonC(new int[]{n, n2, n3, n4, n5}, n6, bS) : this.addPolygon(new int[]{n, n2, n3, n4}, bS);
    }

    protected int addPolygonC(int[] nArray, int n, BS bS) {
        if (n != 0) {
            short s;
            if (this.polygonColixes == null || this.polygonCount == 0) {
                this.lastColor = 0;
            }
            if (n == this.lastColor) {
                s = this.lastColix;
            } else {
                this.lastColor = n;
                s = this.lastColix = C.getColix(this.lastColor);
            }
            short s2 = s;
            this.setPolygonColix(this.polygonCount, s2);
        }
        return this.addPolygon(nArray, bS);
    }

    private int addPolygon(int[] nArray, BS bS) {
        int n = this.polygonCount;
        if (this.polygonCount == 0) {
            this.polygonIndexes = AU.newInt2(25);
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])AU.doubleLength(this.polygonIndexes);
        }
        if (bS != null) {
            bS.set(this.polygonCount);
        }
        this.polygonIndexes[this.polygonCount++] = nArray;
        return n;
    }

    private void setPolygonColix(int n, short s) {
        if (this.polygonColixes == null) {
            this.polygonColixes = new short[25];
        } else if (n >= this.polygonColixes.length) {
            this.polygonColixes = AU.doubleLengthShort(this.polygonColixes);
        }
        this.polygonColixes[n] = s;
    }

    public void invalidatePolygons() {
        int n = this.polygonCount;
        while (--n >= this.mergePolygonCount0) {
            if (this.bsSlabDisplay != null && !this.bsSlabDisplay.get(n) || this.setABC(n)) continue;
            this.polygonIndexes[n] = null;
        }
    }

    protected boolean setABC(int n) {
        if (!(this.bsSlabDisplay == null || this.bsSlabDisplay.get(n) || this.bsSlabGhost != null && this.bsSlabGhost.get(n))) {
            return false;
        }
        int[] nArray = this.polygonIndexes[n];
        if (nArray == null || nArray.length < 3) {
            return false;
        }
        this.iA = nArray[0];
        this.iB = nArray[1];
        this.iC = nArray[2];
        return this.vertexValues == null || !Float.isNaN(this.vertexValues[this.iA]) && !Float.isNaN(this.vertexValues[this.iB]) && !Float.isNaN(this.vertexValues[this.iC]);
    }

    public void setTranslucentVertices(BS bS) {
    }

    public void setSlab(BS bS, BS bS2, String string, String string2, float f) {
        this.bsSlabDisplay = bS;
        this.bsSlabGhost = bS2;
        this.slabMeshType = string.equalsIgnoreCase("mesh") ? 1073742018 : 1073741938;
        this.slabColix = C.getColixTranslucent3(C.getColixS(string2), true, f);
    }

    public String getSlabColor() {
        return this.bsSlabGhost == null ? null : C.getHexCode(this.slabColix);
    }

    public String getSlabTranslucency() {
        return this.bsSlabGhost == null ? null : "" + C.getColixTranslucencyFractional(this.slabColix);
    }

    public String getSlabType() {
        return this.bsSlabGhost != null && this.slabMeshType == 1073742018 ? "mesh" : null;
    }

    public void resetTransPolygons() {
        boolean bl = C.isColixTranslucent(this.colix);
        float f = C.getColixTranslucencyFractional(this.colix);
        for (int i = 0; i < this.polygonCount; ++i) {
            if (!this.bsTransPolygons.get(i) || !this.setABC(i)) continue;
            this.vertexColixes[this.iA] = C.getColixTranslucent3(this.vertexColixes[this.iA], bl, f);
            this.vertexColixes[this.iB] = C.getColixTranslucent3(this.vertexColixes[this.iB], bl, f);
            this.vertexColixes[this.iC] = C.getColixTranslucent3(this.vertexColixes[this.iC], bl, f);
        }
        this.bsTransPolygons = null;
        this.polygonTranslucencies = null;
    }

    public void resetSlab() {
        this.slabPolygons(TempArray.getSlabObjectType(0x10000B, null, false, null), false);
    }

    public static Object[] getCapSlabObject(String string, boolean bl) {
        try {
            if (string.indexOf("array") == 0) {
                String[] stringArray = PT.split(string.substring(6, string.length() - 1), ",");
                return TempArray.getSlabObjectType(1679429641, new P3[]{(P3)Escape.uP(stringArray[0]), (P3)Escape.uP(stringArray[1]), (P3)Escape.uP(stringArray[2]), (P3)Escape.uP(stringArray[3])}, bl, null);
            }
            Object object = Escape.uP(string);
            if (object instanceof P4) {
                return TempArray.getSlabObjectType(135266319, object, bl, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void slabPolygonsList(List<Object[]> list, boolean bl) {
        for (int i = 0; i < list.size() && this.slabPolygons((Object[])list.get(i), bl); ++i) {
        }
    }

    public boolean slabPolygons(Object[] objectArray, boolean bl) {
        Object object;
        SB sB;
        block34: {
            boolean bl2;
            boolean bl3;
            if (this.polygonCount0 < 0) {
                return false;
            }
            int n = (Integer)objectArray[0];
            if (n == 0x10000B || n == 0x40000030) {
                if (this.bsSlabDisplay != null && (this.polygonCount0 != 0 || this.vertexCount0 != 0)) {
                    this.polygonCount = this.polygonCount0;
                    this.vertexCount = this.vertexCount0;
                    this.vertexCount0 = 0;
                    this.polygonCount0 = 0;
                    this.normixCount = this.isTriangleSet ? this.polygonCount : this.vertexCount;
                    this.bsSlabDisplay.setBits(0, this.polygonCount == 0 ? this.vertexCount : this.polygonCount);
                    this.slabOptions = new SB().append(this.meshType + " slab none");
                    this.bsSlabGhost = null;
                    this.slabMeshType = 0x10000B;
                }
                if (n == 0x10000B) {
                    return false;
                }
            }
            Object object2 = objectArray[1];
            boolean bl4 = bl3 = (Boolean)objectArray[2] != false && n != 0x40000030;
            if (bl3 && !bl) {
                return false;
            }
            Object[] objectArray2 = (Object[])objectArray[3];
            boolean bl5 = bl2 = objectArray2 != null;
            if (this.bsSlabDisplay == null || this.polygonCount0 == 0 && this.vertexCount0 == 0) {
                this.polygonCount0 = this.polygonCount;
                this.vertexCount0 = this.vertexCount;
                this.bsSlabDisplay = BSUtil.setAll(this.polygonCount == 0 ? this.vertexCount : this.polygonCount);
                this.bsSlabGhost = null;
                if (this.polygonCount == 0 && this.vertexCount == 0) {
                    return false;
                }
            } else if (this.isMerged) {
                if (this.polygonCount == 0) {
                    this.bsSlabDisplay.setBits(this.mergeVertexCount0, this.vertexCount);
                } else {
                    this.bsSlabDisplay.setBits(this.mergePolygonCount0, this.polygonCount);
                }
            }
            if (bl2) {
                if (this.bsSlabGhost == null) {
                    this.bsSlabGhost = new BS();
                }
                this.slabMeshType = (Integer)objectArray2[0];
                this.slabColix = (Short)objectArray2[1];
                bl3 = false;
                this.colix = C.getColixTranslucent3(this.colix, false, 0.0f);
            }
            sB = new SB();
            sB.append(bl3 ? " cap " : " slab ");
            if (bl2) {
                sB.append("translucent ").appendF(C.getColixTranslucencyFractional(this.slabColix)).append(" ");
                object = C.getHexCode(this.slabColix);
                if (object != null) {
                    sB.append((String)object).append(" ");
                }
                if (this.slabMeshType == 1073742018) {
                    sB.append("mesh ");
                }
            }
            block0 : switch (n) {
                case 0x40000030: {
                    sB.append("brillouin");
                    this.slabBrillouin((P3[])object2);
                    break;
                }
                case 3: {
                    this.getIntersection(0.0f, null, null, null, null, (BS)object2, null, bl3, false, 3, bl2);
                    break;
                }
                case 135266319: {
                    object = (P4)object2;
                    sB.append(Escape.eP4((P4)object));
                    this.getIntersection(0.0f, (P4)object, null, null, null, null, null, bl3, false, 135266319, bl2);
                    break;
                }
                case 1614417948: 
                case 1679429641: {
                    T3[] t3Array = (P3[])object2;
                    sB.append("within ").append(Escape.eAP(t3Array));
                    P4[] p4Array = BoxInfo.getFacesFromCriticalPoints((P3[])t3Array);
                    for (int i = 0; i < p4Array.length; ++i) {
                        this.getIntersection(0.0f, p4Array[i], null, null, null, null, null, bl3, false, 135266319, bl2);
                    }
                    break;
                }
                case 135270407: {
                    this.getIntersection(0.0f, null, null, null, (float[])object2, null, null, false, false, 32, bl2);
                    break;
                }
                case 135266325: 
                case 1073742018: 
                case 1073742114: {
                    Object[] objectArray3 = (Object[])object2;
                    float f = ((Float)objectArray3[0]).floatValue();
                    switch (n) {
                        case 135266325: {
                            P3[] p3Array = (P3[])objectArray3[1];
                            BS bS = (BS)objectArray3[2];
                            sB.append("within ").appendF(f).append(bS == null ? Escape.e(p3Array) : Escape.e(bS));
                            this.getIntersection(f, null, p3Array, null, null, null, null, bl3, false, f > 0.0f ? 1276118018 : 1073742154, bl2);
                            break block0;
                        }
                        case 1073742114: {
                            if (this.vertexValues == null) {
                                return false;
                            }
                            float f2 = ((Float)objectArray3[1]).floatValue();
                            sB.append("within range ").appendF(f).append(" ").appendF(f2);
                            BS bS = f2 < f ? BSUtil.copy(this.bsSlabDisplay) : null;
                            this.getIntersection(f, null, null, null, null, null, null, bl3, false, 32, bl2);
                            BS bS2 = bS == null ? null : BSUtil.copy(this.bsSlabDisplay);
                            BSUtil.copy2(bS, this.bsSlabDisplay);
                            this.getIntersection(f2, null, null, null, null, null, null, bl3, false, 64, bl2);
                            if (bS2 != null) {
                                this.bsSlabDisplay.or(bS2);
                                break block0;
                            }
                            break block34;
                        }
                        case 1073742018: {
                            MeshSurface meshSurface = (MeshSurface)objectArray3[1];
                            this.getIntersection(0.0f, null, null, null, null, null, meshSurface, bl3, false, f < 0.0f ? 32 : 64, bl2);
                        }
                    }
                }
            }
        }
        object = sB.toString();
        if (this.slabOptions == null) {
            this.slabOptions = new SB();
        }
        if (this.slabOptions.indexOf((String)object) < 0) {
            this.slabOptions.append(this.slabOptions.length() > 0 ? "; " : "").append(this.meshType).append((String)object);
        }
        return true;
    }

    protected void slabBrillouin(P3[] p3Array) {
    }

    protected int addIntersectionVertex(P3 p3, float f, int n, int n2, Map<String, Integer> map, int n3, int n4) {
        Integer n5;
        String string;
        String string2 = string = n3 > n4 ? n4 + "_" + n3 : n3 + "_" + n4;
        if (n3 >= 0 && (n5 = map.get(string)) != null) {
            return n5;
        }
        if (this.vertexSource != null) {
            if (this.vertexCount >= this.vertexSource.length) {
                this.vertexSource = AU.doubleLengthI(this.vertexSource);
            }
            this.vertexSource[this.vertexCount] = n;
        }
        if (this.vertexSets != null) {
            if (this.vertexCount >= this.vertexSets.length) {
                this.vertexSets = AU.doubleLengthI(this.vertexSets);
            }
            this.vertexSets[this.vertexCount] = n2;
        }
        int n6 = this.addVCVal(p3, f);
        map.put(string, n6);
        return n6;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getIntersection(float f, P4 p4, P3[] p3Array, List<P3[]> list, float[] fArray, BS bS, MeshSurface meshSurface, boolean bl, boolean bl2, int n, boolean bl3) {
        int n2;
        Object object;
        int n3;
        List<int[]> list2;
        boolean bl4 = list == null;
        P3[] p3Array2 = null;
        if (fArray == null) {
            if (n == 3 && bS != null) {
                fArray = new float[this.vertexCount];
                for (int i = 0; i < this.vertexCount; ++i) {
                    fArray[i] = this.vertexSource[i];
                    if (fArray[i] != -1.0f) continue;
                    System.out.println("meshsurface hmm");
                }
            } else {
                fArray = this.vertexValues;
            }
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        if (p3Array != null || bl3) {
            bl = false;
        }
        float[] fArray2 = new float[2];
        float[] fArray3 = new float[2];
        double d = Math.abs(f);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        List<int[]> list3 = list2 = bl ? new List<int[]>() : null;
        if (this.polygonCount == 0) {
            int n8 = this.mergeVertexCount0;
            while (true) {
                if (n8 >= this.vertexCount) {
                    return;
                }
                if (Float.isNaN(fArray[n8]) || MeshSurface.checkSlab(n, this.vertices[n8], fArray[n8], f, p4, p3Array, bS) > 0.0f) {
                    this.bsSlabDisplay.clear(n8);
                }
                ++n8;
            }
        }
        int n9 = this.polygonCount;
        block14: for (int i = this.mergePolygonCount0; i < n9; ++i) {
            if (!this.setABC(i)) continue;
            BS bS2 = this.bsSlabGhost != null && this.bsSlabGhost.get(i) ? this.bsSlabGhost : this.bsSlabDisplay;
            n3 = this.polygonIndexes[i][3];
            int n10 = this.checkCount == 2 ? this.polygonIndexes[i][4] : 0;
            object = this.vertices[this.iA];
            P3 p3 = this.vertices[this.iB];
            P3 p32 = this.vertices[this.iC];
            float f2 = fArray[this.iA];
            float f3 = fArray[this.iB];
            float f4 = fArray[this.iC];
            if (this.vertexSource != null) {
                n4 = this.vertexSource[this.iA];
                n5 = this.vertexSource[this.iB];
                n6 = this.vertexSource[this.iC];
            }
            if (this.vertexSets != null) {
                n7 = this.vertexSets[this.iA];
            }
            float f5 = MeshSurface.checkSlab(n, (P3)object, f2, bS == null ? f : (float)n4, p4, p3Array, bS);
            float f6 = MeshSurface.checkSlab(n, p3, f3, bS == null ? f : (float)n5, p4, p3Array, bS);
            float f7 = MeshSurface.checkSlab(n, p32, f4, bS == null ? f : (float)n6, p4, p3Array, bS);
            n2 = (f5 != 0.0f && f5 < 0.0f ? 1 : 0) + (f6 != 0.0f && f6 < 0.0f ? 2 : 0) + (f7 != 0.0f && f7 < 0.0f ? 4 : 0);
            switch (n2) {
                default: {
                    break;
                }
                case 1: 
                case 6: {
                    if (p3Array == null) {
                        p3Array2 = new P3[]{MeshSurface.interpolatePoint((P3)object, p3, -f5, f6, f2, f3, fArray2, fArray3, 0), MeshSurface.interpolatePoint((P3)object, p32, -f5, f7, f2, f4, fArray2, fArray3, 1)};
                        break;
                    }
                    p3Array2 = new P3[]{this.interpolateSphere((P3)object, p3, -f5, -f6, d, f2, f3, fArray2, fArray3, 0), this.interpolateSphere((P3)object, p32, -f5, -f7, d, f2, f4, fArray2, fArray3, 1)};
                    break;
                }
                case 2: 
                case 5: {
                    if (p3Array == null) {
                        p3Array2 = new P3[]{MeshSurface.interpolatePoint(p3, (P3)object, -f6, f5, f3, f2, fArray2, fArray3, 1), MeshSurface.interpolatePoint(p3, p32, -f6, f7, f3, f4, fArray2, fArray3, 0)};
                        break;
                    }
                    p3Array2 = new P3[]{this.interpolateSphere(p3, (P3)object, -f6, -f5, d, f3, f2, fArray2, fArray3, 1), this.interpolateSphere(p3, p32, -f6, -f7, d, f3, f4, fArray2, fArray3, 0)};
                    break;
                }
                case 3: 
                case 4: {
                    p3Array2 = p3Array == null ? new P3[]{MeshSurface.interpolatePoint(p32, (P3)object, -f7, f5, f4, f2, fArray2, fArray3, 0), MeshSurface.interpolatePoint(p32, p3, -f7, f6, f4, f3, fArray2, fArray3, 1)} : new P3[]{this.interpolateSphere(p32, (P3)object, -f7, -f5, d, f4, f2, fArray2, fArray3, 0), this.interpolateSphere(p32, p3, -f7, -f6, d, f4, f3, fArray2, fArray3, 1)};
                }
            }
            this.doClear = true;
            this.doGhost = bl3;
            this.doCap = bl;
            if (bl4) {
                switch (n2) {
                    case 0: {
                        this.doCap = false;
                        break;
                    }
                    case 7: {
                        continue block14;
                    }
                    case 1: 
                    case 6: {
                        BS bS3;
                        boolean bl5;
                        boolean bl6 = bl5 = n2 == 1;
                        if (bl5 || bl3) {
                            if (!this.getDE(fArray3, 0, this.iA, this.iB, this.iC, bl5)) break;
                            if (this.iD < 0) {
                                this.iD = this.addIntersectionVertex(p3Array2[0], fArray2[0], n4, n7, hashtable, this.iA, this.iB);
                            }
                            if (this.iE < 0) {
                                this.iE = this.addIntersectionVertex(p3Array2[1], fArray2[1], n4, n7, hashtable, this.iA, this.iC);
                            }
                            bS3 = bl5 ? bS2 : this.bsSlabGhost;
                            this.addPolygonV3(this.iA, this.iD, this.iE, n3 & 5 | 2, n10, 0, bS3);
                            if (!bl3) break;
                        }
                        if (!this.getDE(fArray3, 1, this.iA, this.iC, this.iB, bl5)) break;
                        BS bS4 = bS3 = bl5 ? this.bsSlabGhost : bS2;
                        if (this.iE < 0) {
                            this.iE = this.addIntersectionVertex(p3Array2[0], fArray2[0], n5, n7, hashtable, this.iA, this.iB);
                            this.addPolygonV3(this.iE, this.iB, this.iC, n3 & 3, n10, 0, bS3);
                        }
                        if (this.iD >= 0) break;
                        this.iD = this.addIntersectionVertex(p3Array2[1], fArray2[1], n6, n7, hashtable, this.iA, this.iC);
                        this.addPolygonV3(this.iD, this.iE, this.iC, n3 & 4 | 1, n10, 0, bS3);
                        break;
                    }
                    case 2: 
                    case 5: {
                        boolean bl7;
                        BS bS3;
                        boolean bl8 = bl7 = n2 == 2;
                        if (bl7 || bl3) {
                            if (!this.getDE(fArray3, 0, this.iB, this.iC, this.iA, bl7)) break;
                            BS bS5 = bS3 = bl7 ? bS2 : this.bsSlabGhost;
                            if (this.iE < 0) {
                                this.iE = this.addIntersectionVertex(p3Array2[0], fArray2[0], n5, n7, hashtable, this.iB, this.iA);
                            }
                            if (this.iD < 0) {
                                this.iD = this.addIntersectionVertex(p3Array2[1], fArray2[1], n5, n7, hashtable, this.iB, this.iC);
                            }
                            this.addPolygonV3(this.iE, this.iB, this.iD, n3 & 3 | 4, n10, 0, bS3);
                            if (!bl3) break;
                        }
                        if (!this.getDE(fArray3, 1, this.iB, this.iA, this.iC, bl7)) break;
                        BS bS6 = bS3 = bl7 ? this.bsSlabGhost : bS2;
                        if (this.iD < 0) {
                            this.iD = this.addIntersectionVertex(p3Array2[0], fArray2[0], n4, n7, hashtable, this.iB, this.iA);
                            this.addPolygonV3(this.iA, this.iD, this.iC, n3 & 5, n10, 0, bS3);
                        }
                        if (this.iE >= 0) break;
                        this.iE = this.addIntersectionVertex(p3Array2[1], fArray2[1], n6, n7, hashtable, this.iB, this.iC);
                        this.addPolygonV3(this.iD, this.iE, this.iC, n3 & 2 | 1, n10, 0, bS3);
                        break;
                    }
                    case 3: 
                    case 4: {
                        boolean bl9;
                        BS bS3;
                        boolean bl10 = bl9 = n2 == 4;
                        if (bl9 || bl3) {
                            if (!this.getDE(fArray3, 0, this.iC, this.iA, this.iB, bl9)) break;
                            if (this.iD < 0) {
                                this.iD = this.addIntersectionVertex(p3Array2[0], fArray2[0], n6, n7, hashtable, this.iA, this.iC);
                            }
                            if (this.iE < 0) {
                                this.iE = this.addIntersectionVertex(p3Array2[1], fArray2[1], n6, n7, hashtable, this.iB, this.iC);
                            }
                            bS3 = bl9 ? bS2 : this.bsSlabGhost;
                            this.addPolygonV3(this.iD, this.iE, this.iC, n3 & 6 | 1, n10, 0, bS3);
                            if (!bl3) break;
                        }
                        if (!this.getDE(fArray3, 1, this.iC, this.iB, this.iA, bl9)) break;
                        BS bS7 = bS3 = bl9 ? this.bsSlabGhost : bS2;
                        if (this.iE < 0) {
                            this.iE = this.addIntersectionVertex(p3Array2[0], fArray2[0], n4, n7, hashtable, this.iA, this.iC);
                            this.addPolygonV3(this.iA, this.iB, this.iE, n3 & 5, n10, 0, bS3);
                        }
                        if (this.iD >= 0) break;
                        this.iD = this.addIntersectionVertex(p3Array2[1], fArray2[1], n5, n7, hashtable, this.iB, this.iC);
                        this.addPolygonV3(this.iE, this.iB, this.iD, n3 & 2 | 4, n10, 0, bS3);
                    }
                }
                if (this.doClear) {
                    bS2.clear(i);
                    if (this.doGhost) {
                        this.bsSlabGhost.set(i);
                    }
                }
                if (!this.doCap) continue;
                list2.addLast(new int[]{this.iD, this.iE});
                continue;
            }
            if (p3Array2 == null) continue;
            list.addLast(p3Array2);
        }
        if (bl && list2.size() > 0) {
            P3 p3 = new P3();
            int n11 = list2.size();
            while (--n11 >= 0) {
                int[] nArray = (int[])list2.get(n11);
                p3.add(this.vertices[nArray[0]]);
                p3.add(this.vertices[nArray[1]]);
            }
            p3.scale(0.5f / (float)list2.size());
            n11 = this.addIntersectionVertex(p3, 0.0f, -1, n7, hashtable, -1, -1);
            n3 = list2.size();
            while (--n3 >= 0) {
                int[] nArray = (int[])list2.get(n3);
                this.addPolygonV3(nArray[0], n11, nArray[1], 0, 0, 0, this.bsSlabDisplay);
            }
        }
        if (!bl2) {
            return;
        }
        BS bS8 = new BS();
        BS bS9 = new BS();
        for (n3 = 0; n3 < this.polygonCount; ++n3) {
            if (this.polygonIndexes[n3] == null) continue;
            bS9.set(n3);
            for (int i = 0; i < 3; ++i) {
                bS8.set(this.polygonIndexes[n3][i]);
            }
        }
        n3 = 0;
        int n12 = bS9.cardinality();
        if (n12 == this.polygonCount) return;
        object = new int[this.vertexCount];
        for (int i = 0; i < this.vertexCount; ++i) {
            if (!bS8.get(i)) continue;
            object[i] = n3++;
        }
        P3[] p3Array3 = new P3[n3];
        n3 = 0;
        for (int i = 0; i < this.vertexCount; ++i) {
            if (!bS8.get(i)) continue;
            p3Array3[n3++] = this.vertices[i];
        }
        int[][] nArray = AU.newInt2(n12);
        n12 = 0;
        n2 = 0;
        while (true) {
            if (n2 >= this.polygonCount) {
                this.vertices = p3Array3;
                this.vertexCount = n3;
                this.polygonIndexes = nArray;
                this.polygonCount = n12;
                return;
            }
            if (this.polygonIndexes[n2] != null) {
                for (int i = 0; i < 3; ++i) {
                    this.polygonIndexes[n2][i] = (int)object[this.polygonIndexes[n2][i]];
                }
                nArray[n12++] = this.polygonIndexes[n2];
            }
            ++n2;
        }
    }

    private static int setPoint(float[] fArray, int n, int n2, int n3) {
        return fArray[n] == 0.0f ? n2 : (fArray[n] == 1.0f ? n3 : -1);
    }

    private boolean getDE(float[] fArray, int n, int n2, int n3, int n4, boolean bl) {
        this.iD = MeshSurface.setPoint(fArray, n, n2, n3);
        this.iE = MeshSurface.setPoint(fArray, 1 - n, n2, n4);
        if (this.iD == n2 && this.iE == n2) {
            this.doClear = bl;
            this.doCap = false;
            return false;
        }
        if (this.iD == n3 && this.iE == n4) {
            this.doClear = !bl;
            return false;
        }
        if (this.iD == n2 || this.iE == n2) {
            this.doClear = bl;
            if (this.iD < 0) {
                this.iD = bl ? n3 : n4;
            } else if (this.iE < 0) {
                this.iE = bl ? n4 : n3;
            }
            return this.doCap;
        }
        this.doGhost = false;
        return true;
    }

    private static float checkSlab(int n, P3 p3, float f, float f2, P4 p4, P3[] p3Array, BS bS) {
        float f3;
        switch (n) {
            case 3: {
                return f >= 0.0f && bS.get((int)f) ? 1 : -1;
            }
            case 32: {
                f3 = f2 - f;
                break;
            }
            case 64: {
                f3 = f - f2;
                break;
            }
            case 135266319: {
                f3 = Measure.distanceToPlane(p4, p3);
                break;
            }
            case 1276118018: {
                f3 = MeshSurface.minDist(p3, p3Array) - f2;
                break;
            }
            default: {
                f3 = -MeshSurface.minDist(p3, p3Array) - f2;
            }
        }
        return Math.abs(f3) < 1.0E-4f ? 0.0f : f3;
    }

    private static float minDist(P3 p3, P3[] p3Array) {
        float f = 2.1474836E9f;
        int n = p3Array.length;
        while (--n >= 0) {
            float f2 = p3Array[n].distance(p3);
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    private P3 interpolateSphere(P3 p3, P3 p32, float f, float f2, double d, float f3, float f4, float[] fArray, float[] fArray2, int n) {
        return MeshSurface.interpolateFraction(p3, p32, MeshSurface.getSphericalInterpolationFraction(d, f, f2, p3.distance(p32)), f3, f4, fArray, fArray2, n);
    }

    private static P3 interpolatePoint(P3 p3, P3 p32, float f, float f2, float f3, float f4, float[] fArray, float[] fArray2, int n) {
        return MeshSurface.interpolateFraction(p3, p32, f / (f + f2), f3, f4, fArray, fArray2, n);
    }

    private static P3 interpolateFraction(P3 p3, P3 p32, float f, float f2, float f3, float[] fArray, float[] fArray2, int n) {
        if ((double)f < 1.0E-4) {
            f = 0.0f;
        } else if ((double)f > 0.9999) {
            f = 1.0f;
        }
        fArray2[n] = f;
        fArray[n] = (f3 - f2) * f + f2;
        return P3.new3(p3.x + (p32.x - p3.x) * f, p3.y + (p32.y - p3.y) * f, p3.z + (p32.z - p3.z) * f);
    }

    public static float getSphericalInterpolationFraction(double d, double d2, double d3, double d4) {
        double d5 = Math.abs(d + d2) / d4;
        double d6 = Math.abs(d + d3) / d4;
        double d7 = d5 * d5;
        double d8 = d7 - d6 * d6 + 1.0;
        double d9 = 4.0 * ((d /= d4) * d - d7);
        double d10 = d5 < d6 ? 1 : -1;
        return (float)((d8 + d10 * Math.sqrt(d8 * d8 + d9)) / 2.0);
    }

    public static MeshSurface getSphereData(int n) {
        Geodesic.createGeodesic(n);
        int n2 = Geodesic.getVertexCount(n);
        short[] sArray = Geodesic.getFaceVertexes(n);
        int n3 = sArray.length / 3;
        int[][] nArray = AU.newInt2(n3);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            nArray[i] = new int[]{sArray[n4++], sArray[n4++], sArray[n4++]};
        }
        T3[] t3Array = new V3[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            t3Array[n4] = Geodesic.getVertexVector(n4);
        }
        return MeshSurface.newMesh(true, t3Array, 0, nArray, t3Array, 0);
    }
}

