/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.List;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolNode;

public class JmolMolecule {
    public JmolNode[] nodes;
    public int moleculeIndex;
    public int modelIndex;
    public int indexInModel;
    public int firstAtomIndex;
    public int atomCount;
    public int nElements;
    public int[] elementCounts = new int[Elements.elementNumberMax];
    public int[] altElementCounts = new int[Elements.altElementMax];
    public int elementNumberMax;
    public int altElementMax;
    public String mf;
    public BS atomList;

    public static final JmolMolecule[] getMolecules(JmolNode[] jmolNodeArray, BS[] bSArray, List<BS> list, BS bS) {
        BS bS2 = null;
        BS bS3 = new BS();
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        JmolMolecule[] jmolMoleculeArray = new JmolMolecule[4];
        if (bS == null) {
            bS = new BS();
        }
        for (int i = 0; i < jmolNodeArray.length; ++i) {
            if (bS.get(i) || bS3.get(i)) continue;
            if (jmolNodeArray[i].isDeleted()) {
                bS.set(i);
                continue;
            }
            int n4 = jmolNodeArray[i].getModelIndex();
            if (n4 != n) {
                n = n4;
                n2 = 0;
                bS2 = bSArray[n4];
            }
            if ((bS3 = JmolMolecule.getBranchBitSet(jmolNodeArray, i, bS2, list, -1, true, true)).nextSetBit(0) < 0) continue;
            jmolMoleculeArray = JmolMolecule.addMolecule(jmolMoleculeArray, n3++, jmolNodeArray, i, bS3, n4, n2++, bS);
        }
        return JmolMolecule.allocateArray(jmolMoleculeArray, n3);
    }

    public static BS getBranchBitSet(JmolNode[] jmolNodeArray, int n, BS bS, List<BS> list, int n2, boolean bl, boolean bl2) {
        BS bS2 = BSUtil.newBitSet(jmolNodeArray.length);
        if (n < 0) {
            return bS2;
        }
        if (n2 >= 0) {
            bS.clear(n2);
        }
        return JmolMolecule.getCovalentlyConnectedBitSet(jmolNodeArray, jmolNodeArray[n], bS, bl, bl2, list, bS2) ? bS2 : new BS();
    }

    public static final JmolMolecule[] addMolecule(JmolMolecule[] jmolMoleculeArray, int n, JmolNode[] jmolNodeArray, int n2, BS bS, int n3, int n4, BS bS2) {
        bS2.or(bS);
        if (n == jmolMoleculeArray.length) {
            jmolMoleculeArray = JmolMolecule.allocateArray(jmolMoleculeArray, n * 2 + 1);
        }
        jmolMoleculeArray[n] = JmolMolecule.initialize(jmolNodeArray, n, n2, bS, n3, n4);
        return jmolMoleculeArray;
    }

    public static String getMolecularFormula(JmolNode[] jmolNodeArray, BS bS, boolean bl) {
        JmolMolecule jmolMolecule = new JmolMolecule();
        jmolMolecule.nodes = jmolNodeArray;
        jmolMolecule.atomList = bS;
        return jmolMolecule.getMolecularFormula(bl);
    }

    public String getMolecularFormula(boolean bl) {
        int n;
        int n2;
        if (this.mf != null) {
            return this.mf;
        }
        this.getElementAndAtomCount(bl);
        String string = "";
        String string2 = "";
        for (n2 = 1; n2 <= this.elementNumberMax; ++n2) {
            n = this.elementCounts[n2];
            if (n == 0) continue;
            string = string + string2 + Elements.elementSymbolFromNumber(n2) + " " + n;
            string2 = " ";
        }
        for (n2 = 1; n2 <= this.altElementMax; ++n2) {
            n = this.altElementCounts[n2];
            if (n == 0) continue;
            string = string + string2 + Elements.elementSymbolFromNumber(Elements.altElementNumberFromIndex(n2)) + " " + n;
            string2 = " ";
        }
        return string;
    }

    private static JmolMolecule initialize(JmolNode[] jmolNodeArray, int n, int n2, BS bS, int n3, int n4) {
        JmolMolecule jmolMolecule = new JmolMolecule();
        jmolMolecule.nodes = jmolNodeArray;
        jmolMolecule.firstAtomIndex = n2;
        jmolMolecule.atomList = bS;
        jmolMolecule.atomCount = bS.cardinality();
        jmolMolecule.moleculeIndex = n;
        jmolMolecule.modelIndex = n3;
        jmolMolecule.indexInModel = n4;
        return jmolMolecule;
    }

    private void getElementAndAtomCount(boolean bl) {
        if (this.atomList == null) {
            this.atomList = new BS();
            this.atomList.setBits(0, this.nodes.length);
        }
        this.elementCounts = new int[Elements.elementNumberMax];
        this.altElementCounts = new int[Elements.altElementMax];
        this.atomCount = this.atomList.cardinality();
        int n = this.atomList.nextSetBit(0);
        while (n >= 0) {
            int n2 = this.nodes[n].getAtomicAndIsotopeNumber();
            if (n2 < Elements.elementNumberMax) {
                int n3;
                int n4 = n2;
                this.elementCounts[n4] = this.elementCounts[n4] + 1;
                if (this.elementCounts[n2] == 1) {
                    ++this.nElements;
                }
                this.elementNumberMax = Math.max(this.elementNumberMax, n2);
                if (bl && (n3 = this.nodes[n].getImplicitHydrogenCount()) > 0) {
                    if (this.elementCounts[1] == 0) {
                        ++this.nElements;
                    }
                    this.elementCounts[1] = this.elementCounts[1] + n3;
                }
            } else {
                int n5 = n2 = Elements.altElementIndexFromNumber(n2);
                this.altElementCounts[n5] = this.altElementCounts[n5] + 1;
                if (this.altElementCounts[n2] == 1) {
                    ++this.nElements;
                }
                this.altElementMax = Math.max(this.altElementMax, n2);
            }
            n = this.atomList.nextSetBit(n + 1);
        }
    }

    private static boolean getCovalentlyConnectedBitSet(JmolNode[] jmolNodeArray, JmolNode jmolNode, BS bS, boolean bl, boolean bl2, List<BS> list, BS bS2) {
        int n = jmolNode.getIndex();
        if (!bS.get(n)) {
            return bl;
        }
        if (!bl2 && jmolNode.getBioStructureTypeName().length() > 0) {
            return bl;
        }
        bS.clear(n);
        if (list != null && !bS2.get(n)) {
            int n2 = list.size();
            while (--n2 >= 0) {
                BS bS3 = (BS)list.get(n2);
                if (!bS3.get(n)) continue;
                bS2.or(bS3);
                bS.andNot(bS3);
                int n3 = bS3.nextSetBit(0);
                while (n3 >= 0) {
                    JmolNode jmolNode2 = jmolNodeArray[n3];
                    bS.set(n3);
                    JmolMolecule.getCovalentlyConnectedBitSet(jmolNodeArray, jmolNode2, bS, bl, bl2, list, bS2);
                    bS.clear(n3);
                    n3 = bS3.nextSetBit(n3 + 1);
                }
                break block0;
            }
        }
        bS2.set(n);
        JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
        if (jmolEdgeArray == null) {
            return true;
        }
        int n4 = jmolEdgeArray.length;
        while (--n4 >= 0) {
            JmolEdge jmolEdge = jmolEdgeArray[n4];
            if (!jmolEdge.isCovalent() || JmolMolecule.getCovalentlyConnectedBitSet(jmolNodeArray, jmolEdge.getOtherAtomNode(jmolNode), bS, bl, bl2, list, bS2)) continue;
            return false;
        }
        return true;
    }

    private static JmolMolecule[] allocateArray(JmolMolecule[] jmolMoleculeArray, int n) {
        return n == jmolMoleculeArray.length ? jmolMoleculeArray : (JmolMolecule[])AU.arrayCopyObject(jmolMoleculeArray, n);
    }
}

