/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Map;
import javajs.util.A4;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.java.BS;
import org.jmol.script.SV;
import org.jmol.util.BSUtil;

public class Escape {
    private static final String escapable = "\\\\\tt\rr\nn\"\"";

    public static String escapeColor(int n) {
        return n == 0 ? null : "[x" + Escape.getHexColorFromRGB(n) + "]";
    }

    public static String getHexColorFromRGB(int n) {
        if (n == 0) {
            return null;
        }
        String string = "00" + Integer.toHexString(n >> 16 & 0xFF);
        string = string.substring(string.length() - 2);
        String string2 = "00" + Integer.toHexString(n >> 8 & 0xFF);
        string2 = string2.substring(string2.length() - 2);
        String string3 = "00" + Integer.toHexString(n & 0xFF);
        string3 = string3.substring(string3.length() - 2);
        return string + string2 + string3;
    }

    public static String eP(T3 t3) {
        if (t3 == null) {
            return "null";
        }
        return "{" + t3.x + " " + t3.y + " " + t3.z + "}";
    }

    public static String matrixToScript(Object object) {
        return PT.replaceAllCharacters(object.toString(), "\n\r ", "").replace('\t', ' ');
    }

    public static String eP4(P4 p4) {
        return "{" + p4.x + " " + p4.y + " " + p4.z + " " + p4.w + "}";
    }

    public static String e(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return Escape.eS((String)object);
        }
        if (object instanceof List) {
            return Escape.eV((List)object);
        }
        if (object instanceof BS) {
            return Escape.eBS((BS)object);
        }
        if (object instanceof T3) {
            return Escape.eP((T3)object);
        }
        if (object instanceof P4) {
            return Escape.eP4((P4)object);
        }
        if (PT.isAS(object)) {
            return Escape.eAS((String[])object, true);
        }
        if (PT.isAI(object)) {
            return Escape.eAI((int[])object);
        }
        if (PT.isAF(object)) {
            return Escape.eAF((float[])object);
        }
        if (PT.isAD(object)) {
            return Escape.eAD((double[])object);
        }
        if (PT.isAP(object)) {
            return Escape.eAP((P3[])object);
        }
        if (object instanceof M3) {
            return PT.simpleReplace(((M3)object).toString(), "\t", ",\t");
        }
        if (object instanceof M4) {
            return PT.simpleReplace(((M4)object).toString(), "\t", ",\t");
        }
        if (object instanceof A4) {
            A4 a4 = (A4)object;
            return "{" + a4.x + " " + a4.y + " " + a4.z + " " + (float)((double)a4.angle * 180.0 / Math.PI) + "}";
        }
        if (object instanceof Map) {
            return Escape.escapeMap((Map)object);
        }
        if (PT.isAII(object) || PT.isAFF(object) || PT.isADD(object) || PT.isAFFF(object)) {
            return PT.toJSON(null, object);
        }
        return object.toString();
    }

    public static String eS(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        boolean bl = false;
        for (n = 0; n < escapable.length(); n += 2) {
            if (string.indexOf(escapable.charAt(n)) < 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            while (n < escapable.length()) {
                int n2 = -1;
                char c = escapable.charAt(n++);
                char c2 = escapable.charAt(n++);
                SB sB = new SB();
                int n3 = 0;
                while ((n2 = string.indexOf(c, n2 + 1)) >= 0) {
                    sB.append(string.substring(n3, n2)).appendC('\\').appendC(c2);
                    n3 = n2 + 1;
                }
                sB.append(string.substring(n3, string.length()));
                string = sB.toString();
            }
        }
        n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) <= '\u007f') continue;
            string = string.substring(0, n) + Escape.unicode(string.charAt(n)) + string.substring(n + 1);
        }
        return "\"" + string + "\"";
    }

    private static String unicode(char c) {
        String string = "0000" + Integer.toHexString(c);
        return "\\u" + string.substring(string.length() - 4);
    }

    public static String eV(List<SV> list) {
        if (list == null) {
            return Escape.eS("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.append(Escape.escapeNice(((SV)list.get(i)).asString()));
        }
        sB.append("]");
        return sB.toString();
    }

    public static String escapeMap(Map<String, Object> map) {
        SB sB = new SB();
        sB.append("{ ");
        String string = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = entry.getKey();
            sB.append(string).append(Escape.eS(string2)).appendC(':');
            Object object = entry.getValue();
            if (!(object instanceof SV)) {
                object = SV.getVariable(object);
            }
            sB.append(((SV)object).escape());
            string = ",";
        }
        sB.append(" }");
        return sB.toString();
    }

    public static String escapeFloatA(float[] fArray, boolean bl) {
        if (bl) {
            return PT.toJSON(null, fArray);
        }
        SB sB = new SB();
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                sB.appendC('\n');
            }
            sB.appendF(fArray[i]);
        }
        return sB.toString();
    }

    public static String escapeFloatAA(float[][] fArray, boolean bl) {
        SB sB = new SB();
        String string = bl ? ";\n" : "\n";
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == null) continue;
            if (i > 0) {
                sB.append(string);
            }
            for (int j = 0; j < fArray[i].length; ++j) {
                sB.appendF(fArray[i][j]).appendC('\t');
            }
        }
        return sB.toString();
    }

    public static String escapeFloatAAA(float[][][] fArray, boolean bl) {
        String string;
        SB sB = new SB();
        String string2 = string = bl ? ";\n" : "\n";
        if (fArray[0] == null || fArray[0][0] == null) {
            return "0 0 0" + string;
        }
        sB.appendI(fArray.length).append(" ").appendI(fArray[0].length).append(" ").appendI(fArray[0][0].length);
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == null) continue;
            sB.append(string);
            for (int j = 0; j < fArray[i].length; ++j) {
                if (fArray[i][j] == null) continue;
                sB.append(string);
                for (int k = 0; k < fArray[i][j].length; ++k) {
                    sB.appendF(fArray[i][j][k]).appendC('\t');
                }
            }
        }
        return sB.toString();
    }

    public static String eAS(String[] stringArray, boolean bl) {
        if (stringArray == null) {
            return Escape.eS("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.append(bl ? Escape.escapeNice(stringArray[i]) : Escape.eS(stringArray[i]));
        }
        sB.append("]");
        return sB.toString();
    }

    public static String eAI(int[] nArray) {
        if (nArray == null) {
            return Escape.eS("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.appendI(nArray[i]);
        }
        return sB.append("]").toString();
    }

    public static String eAD(double[] dArray) {
        if (dArray == null) {
            return Escape.eS("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.appendD(dArray[i]);
        }
        return sB.append("]").toString();
    }

    public static String eAF(float[] fArray) {
        if (fArray == null) {
            return Escape.eS("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.appendF(fArray[i]);
        }
        return sB.append("]").toString();
    }

    public static String eAP(T3[] t3Array) {
        if (t3Array == null) {
            return Escape.eS("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < t3Array.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.append(Escape.eP(t3Array[i]));
        }
        return sB.append("]").toString();
    }

    private static String escapeNice(String string) {
        if (string == null) {
            return "null";
        }
        float f = PT.parseFloatStrict(string);
        return Float.isNaN(f) ? Escape.eS(string) : string;
    }

    public static Object uABsM(String string) {
        if (string.charAt(0) == '{') {
            return Escape.uP(string);
        }
        if ((Escape.isStringArray(string) || string.startsWith("[{") && string.indexOf("[{") == string.lastIndexOf("[{")) && string.indexOf(44) < 0 && string.indexOf(46) < 0 && string.indexOf(45) < 0) {
            return Escape.uB(string);
        }
        if (string.startsWith("[[")) {
            return Escape.unescapeMatrix(string);
        }
        return string;
    }

    public static boolean isStringArray(String string) {
        return string.startsWith("({") && string.lastIndexOf("({") == 0 && string.indexOf("})") == string.length() - 2;
    }

    public static Object uP(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string.replace('\n', ' ').trim();
        if (string2.charAt(0) != '{' || string2.charAt(string2.length() - 1) != '}') {
            return string;
        }
        float[] fArray = new float[5];
        string2 = string2.substring(1, string2.length() - 1);
        int[] nArray = new int[1];
        for (n = 0; n < 5; ++n) {
            fArray[n] = PT.parseFloatNext(string2, nArray);
            if (!Float.isNaN(fArray[n])) continue;
            if (nArray[0] >= string2.length() || string2.charAt(nArray[0]) != ',') break;
            nArray[0] = nArray[0] + 1;
            --n;
        }
        if (n == 3) {
            return P3.new3(fArray[0], fArray[1], fArray[2]);
        }
        if (n == 4) {
            return P4.new4(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        return string;
    }

    public static BS uB(String string) {
        char c;
        int n;
        if (string == null || (n = (string = string.trim()).length()) < 4 || string.equalsIgnoreCase("({null})") || (c = string.charAt(0)) != '(' && c != '[' || string.charAt(n - 1) != (c == '(' ? (char)')' : ']') || string.charAt(1) != '{' || string.indexOf(125) != n - 2) {
            return null;
        }
        int n2 = n -= 2;
        while (--n2 >= 2) {
            c = string.charAt(n2);
            if (Character.isDigit(c) || c == ' ' || c == '\t' || c == ':') continue;
            return null;
        }
        n2 = n;
        while (Character.isDigit(string.charAt(--n2))) {
        }
        if (++n2 == n) {
            n2 = 0;
        } else {
            try {
                n2 = Integer.parseInt(string.substring(n2, n));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        BS bS = BSUtil.newBitSet(n2);
        n2 = -1;
        int n3 = -1;
        int n4 = -2;
        block8: for (int i = 2; i <= n; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': 
                case '}': {
                    if (n4 < 0) continue block8;
                    if (n4 < n2) {
                        return null;
                    }
                    n2 = n4;
                    if (n3 < 0) {
                        n3 = n4;
                    }
                    bS.setBits(n3, n4 + 1);
                    n3 = -1;
                    n4 = -2;
                    continue block8;
                }
                case ':': {
                    n3 = n2 = n4;
                    n4 = -2;
                    continue block8;
                }
                default: {
                    if (!Character.isDigit(c)) continue block8;
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    n4 = n4 * 10 + (c - 48);
                }
            }
        }
        return n3 >= 0 ? null : bS;
    }

    public static Object unescapeMatrix(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string.replace('\n', ' ').trim();
        if (string2.lastIndexOf("[[") != 0 || string2.indexOf("]]") != string2.length() - 2) {
            return string;
        }
        float[] fArray = new float[16];
        string2 = string2.substring(2, string2.length() - 2).replace('[', ' ').replace(']', ' ').replace(',', ' ');
        int[] nArray = new int[1];
        for (n = 0; n < 16; ++n) {
            fArray[n] = PT.parseFloatNext(string2, nArray);
            if (Float.isNaN(fArray[n])) break;
        }
        if (!Float.isNaN(PT.parseFloatNext(string2, nArray))) {
            return string;
        }
        if (n == 9) {
            return M3.newA(fArray);
        }
        if (n == 16) {
            return M4.newA(fArray);
        }
        return string;
    }

    public static String eBS(BS bS) {
        return Escape.eB(bS, '(', ')');
    }

    public static String eBond(BS bS) {
        return Escape.eB(bS, '[', ']');
    }

    private static String eB(BS bS, char c, char c2) {
        if (bS == null) {
            return c + "{}" + c2;
        }
        SB sB = new SB();
        sB.append(c + "{");
        int n = bS.length();
        int n2 = -1;
        int n3 = -2;
        int n4 = -1;
        while (++n4 <= n) {
            boolean bl = bS.get(n4);
            if (n4 == n || n2 >= 0 && !bl) {
                if (n2 >= 0 && n3 != n2) {
                    sB.append((n3 == n2 - 1 ? " " : ":") + n2);
                }
                if (n4 == n) break;
                n2 = -1;
            }
            if (!bS.get(n4)) continue;
            if (n2 < 0) {
                sB.append((n3 == -2 ? "" : " ") + n4);
                n3 = n4;
            }
            n2 = n4;
        }
        sB.append("}").appendC(c2);
        return sB.toString();
    }

    public static String toReadable(String string, Object object) {
        SB sB = new SB();
        String string2 = "";
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return Escape.packageReadable(string, null, Escape.eS((String)object));
        }
        if (PT.isAS(object)) {
            sB.append("[");
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.eS(((String[])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "String[" + n + "]", sB);
        }
        if (PT.isAI(object)) {
            sB.append("[");
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).appendI(((int[])object)[i]);
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "int[" + n + "]", sB);
        }
        if (PT.isAF(object)) {
            sB.append("[");
            int n = ((float[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).appendF(((float[])object)[i]);
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "float[" + n + "]", sB);
        }
        if (PT.isAD(object)) {
            sB.append("[");
            int n = ((double[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).appendD(((double[])object)[i]);
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "double[" + n + "]", sB);
        }
        if (PT.isAP(object)) {
            sB.append("[");
            int n = ((P3[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.eP(((P3[])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "point3f[" + n + "]", sB);
        }
        if (PT.isASS(object)) {
            sB.append("[");
            int n = ((String[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toReadable(null, ((String[][])object)[i]));
                string2 = ",\n";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "String[" + n + "][]", sB);
        }
        if (PT.isAII(object)) {
            sB.append("[");
            int n = ((int[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toReadable(null, ((int[][])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "int[" + n + "][]", sB);
        }
        if (PT.isAFF(object)) {
            sB.append("[\n");
            int n = ((float[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toReadable(null, ((float[][])object)[i]));
                string2 = ",\n";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "float[][]", sB);
        }
        if (PT.isADD(object)) {
            sB.append("[\n");
            int n = ((double[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toReadable(null, ((double[][])object)[i]));
                string2 = ",\n";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "double[][]", sB);
        }
        if (object instanceof List) {
            int n = ((List)object).size();
            for (int i = 0; i < n; ++i) {
                sB.append(Escape.toReadable(string + "[" + (i + 1) + "]", ((List)object).get(i)));
            }
            return Escape.packageReadableSb(string, "List[" + n + "]", sB);
        }
        if (object instanceof M3 || object instanceof T3 || object instanceof P4 || object instanceof A4) {
            sB.append(Escape.e(object));
            return Escape.packageReadableSb(string, null, sB);
        }
        if (object instanceof Map) {
            for (String string3 : ((Map)object).keySet()) {
                sB.append(Escape.toReadable((string == null ? "" : string + ".") + string3, ((Map)object).get(string3)));
            }
            return sB.toString();
        }
        return Escape.packageReadable(string, null, object.toString());
    }

    private static String packageReadableSb(String string, String string2, SB sB) {
        return Escape.packageReadable(string, string2, sB.toString());
    }

    private static String packageReadable(String string, String string2, String string3) {
        String string4;
        String string5 = string4 = string2 == null ? "" : string2 + "\t";
        if (string == null) {
            return string4 + string3;
        }
        return "\n" + string + "\t" + (string2 == null ? "" : "*" + string2 + "\t") + string3;
    }

    public static String escapeModelFileNumber(int n) {
        return "" + n / 1000000 + "." + n % 1000000;
    }

    public static String encapsulateData(String string, Object object, int n) {
        return "  DATA \"" + string + "\"\n" + (n == 2 ? Escape.escapeFloatAA((float[][])object, true) + ";\n" : (n == 3 ? Escape.escapeFloatAAA((float[][][])object, true) + ";\n" : object)) + "    END \"" + string + "\";\n";
    }

    public static String unescapeUnicode(String string) {
        int n = string.length();
        SB sB = SB.newN(n);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '\\' && n2 < n) {
                c = string.charAt(n2++);
                switch (c) {
                    case 'u': {
                        char c2;
                        int n3;
                        if (n2 >= n) break;
                        int n4 = 0;
                        int n5 = 4;
                        while (--n5 >= 0 && n2 < n && (n3 = Escape.getHexitValue(c2 = string.charAt(n2))) >= 0) {
                            n4 <<= 4;
                            n4 += n3;
                            ++n2;
                        }
                        c = (char)n4;
                    }
                }
            }
            sB.appendC(c);
        }
        return sB.toString();
    }

    public static int getHexitValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }

    public static String[] unescapeStringArray(String string) {
        if (string == null || !string.startsWith("[") || !string.endsWith("]")) {
            return null;
        }
        List<String> list = new List<String>();
        int[] nArray = new int[]{1};
        while (nArray[0] < string.length()) {
            String string2 = PT.getQuotedStringNext(string, nArray);
            if (string2 == null) {
                return null;
            }
            list.addLast(PT.simpleReplace(string2, "\\\"", "\""));
            while (nArray[0] < string.length() && string.charAt(nArray[0]) != '\"') {
                nArray[0] = nArray[0] + 1;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean isAV(Object object) {
        return object instanceof SV[];
    }
}

