/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.thread.JmolThread;
import org.jmol.util.Logger;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.Viewer;

public class AnimationThread
extends JmolThread {
    private AnimationManager animationManager;
    private int framePointer1;
    private int framePointer2;
    private int intThread;
    private boolean isFirst;

    @Override
    public int setManager(Object object, Viewer viewer, Object object2) {
        int[] nArray = (int[])object2;
        this.framePointer1 = nArray[0];
        this.framePointer2 = nArray[1];
        this.intThread = nArray[2];
        this.animationManager = (AnimationManager)object;
        this.setViewer(viewer, "AnimationThread");
        viewer.startHoverWatcher(false);
        return 0;
    }

    @Override
    public void interrupt() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (Logger.debugging) {
            Logger.debug("animation thread interrupted!");
        }
        try {
            this.animationManager.setAnimationOn(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.interrupt();
    }

    @Override
    protected void run1(int n) throws InterruptedException {
        while (true) {
            switch (n) {
                case -1: {
                    if (Logger.debugging) {
                        Logger.debug("animation thread " + this.intThread + " running");
                    }
                    this.viewer.requestRepaintAndWait("animationThread");
                    this.viewer.startHoverWatcher(false);
                    this.isFirst = true;
                    n = 0;
                    break;
                }
                case 0: {
                    if (this.checkInterrupted() || !this.animationManager.animationOn) {
                        n = -2;
                        break;
                    }
                    if (this.animationManager.currentFrameIs(this.framePointer1)) {
                        this.targetTime += (long)this.animationManager.firstFrameDelayMs;
                        this.sleepTime = (int)(this.targetTime - (System.currentTimeMillis() - this.startTime));
                        if (!this.runSleep(this.sleepTime, 1)) {
                            return;
                        }
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    if (this.animationManager.currentFrameIs(this.framePointer2)) {
                        this.targetTime += (long)this.animationManager.lastFrameDelayMs;
                        this.sleepTime = (int)(this.targetTime - (System.currentTimeMillis() - this.startTime));
                        if (!this.runSleep(this.sleepTime, 2)) {
                            return;
                        }
                    }
                    n = 2;
                    break;
                }
                case 2: {
                    if (!this.isFirst && this.animationManager.currentIsLast() && !this.animationManager.setAnimationNext()) {
                        n = -2;
                        break;
                    }
                    this.isFirst = false;
                    this.targetTime += (long)((int)(1000.0f / (float)this.animationManager.animationFps + (float)this.viewer.getFrameDelayMs(this.animationManager.getCurrentModelIndex())));
                    n = 3;
                    break;
                }
                case 3: {
                    while (this.animationManager.animationOn && !this.checkInterrupted() && !this.viewer.getRefreshing()) {
                        if (this.runSleep(10, 3)) continue;
                        return;
                    }
                    if (!this.viewer.getSpinOn()) {
                        this.viewer.refresh(1, "animationThread");
                    }
                    this.sleepTime = (int)(this.targetTime - (System.currentTimeMillis() - this.startTime));
                    if (!this.runSleep(this.sleepTime, 0)) {
                        return;
                    }
                    n = 0;
                    break;
                }
                case -2: {
                    if (Logger.debugging) {
                        Logger.debug("animation thread " + this.intThread + " exiting");
                    }
                    this.animationManager.stopThread(false);
                    return;
                }
            }
        }
    }
}

