/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.P3i;
import org.jmol.renderbio.BioShapeRenderer;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.Strands;

public class StrandsRenderer
extends BioShapeRenderer {
    protected int strandCount = 1;
    protected float strandSeparation;
    protected float baseStrandOffset;

    @Override
    protected void renderBioShape(BioShape bioShape) {
        this.renderStrandShape();
    }

    protected void renderStrandShape() {
        if (!this.setStrandCount()) {
            return;
        }
        this.renderStrands();
    }

    protected boolean setStrandCount() {
        if (this.wingVectors == null) {
            return false;
        }
        this.strandCount = this.shape instanceof Strands ? this.viewer.getStrandCount(((Strands)this.shape).shapeID) : 10;
        this.strandSeparation = this.strandCount <= 1 ? 0.0f : 1.0f / (float)(this.strandCount - 1);
        this.baseStrandOffset = (this.strandCount & 1) == 0 ? this.strandSeparation / 2.0f : this.strandSeparation;
        return true;
    }

    protected void renderStrands() {
        P3i[] p3iArray;
        int n = this.strandCount >> 1;
        while (--n >= 0) {
            float f = (float)n * this.strandSeparation + this.baseStrandOffset;
            p3iArray = this.calcScreens(f);
            this.renderStrand(p3iArray);
            this.viewer.freeTempScreens(p3iArray);
            p3iArray = this.calcScreens(-f);
            this.renderStrand(p3iArray);
            this.viewer.freeTempScreens(p3iArray);
        }
        if (this.strandCount % 2 == 1) {
            p3iArray = this.calcScreens(0.0f);
            this.renderStrand(p3iArray);
            this.viewer.freeTempScreens(p3iArray);
        }
    }

    private void renderStrand(P3i[] p3iArray) {
        int n = this.bsVisible.nextSetBit(0);
        while (n >= 0) {
            this.renderHermiteCylinder(p3iArray, n);
            n = this.bsVisible.nextSetBit(n + 1);
        }
    }
}

