/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import javajs.util.AU;
import javajs.util.List;
import javajs.util.P3;
import org.jmol.api.QuantumPlaneCalculationInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.java.BS;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.util.BSUtil;
import org.jmol.util.Eigen;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class NciCalculation
extends QuantumCalculation
implements QuantumPlaneCalculationInterface {
    private boolean havePoints;
    private boolean isReducedDensity;
    private double DEFAULT_RHOPLOT_SCF = 0.05;
    private double DEFAULT_RHOPLOT_PRO = 0.07;
    private double DEFAULT_RHOPARAM = 0.95;
    private double rhoMin;
    private double rhoPlot;
    private double rhoParam;
    private static final int TYPE_ALL = 0;
    private static final int TYPE_INTRA = 1;
    private static final int TYPE_INTER = 2;
    private static final int TYPE_LIGAND = 3;
    private static final double NO_VALUE = 100.0;
    private float dataScaling = 1.0f;
    private boolean dataIsReducedDensity;
    private Eigen eigen;
    private double[] rhoMolecules;
    private int type;
    private int nMolecules;
    private boolean isPromolecular;
    private BS bsOK;
    private boolean noValuesAtAll;
    private boolean useAbsolute;
    private static double c = 1.0 / (2.0 * Math.pow(29.608813203268074, 0.3333333333333333));
    private static double rpower = -1.3333333333333333;
    private double[][] hess;
    private double grad;
    private double gxTemp;
    private double gyTemp;
    private double gzTemp;
    private double gxxTemp;
    private double gyyTemp;
    private double gzzTemp;
    private double gxyTemp;
    private double gyzTemp;
    private double gxzTemp;
    double test1;
    private float[][] yzPlanesRaw;
    private int yzCount;
    private float[][] yzPlanesRho = AU.newFloat2(2);
    private float[] p0;
    private float[] p1;
    private float[] p2;
    private static double[] coef1 = new double[]{0.0, 0.2815, 2.437, 11.84, 31.34, 67.82, 120.2, 190.9, 289.5, 406.3, 561.3, 760.8, 1016.0, 1319.0, 1658.0, 2042.0, 2501.0, 3024.0, 3625.0};
    private static double[] coef2 = new double[]{0.0, 0.0, 0.0, 0.06332, 0.3694, 0.8527, 1.172, 2.247, 2.879, 3.049, 6.984, 22.42, 37.17, 57.95, 87.16, 115.7, 158.0, 205.5, 260.0};
    private static double[] coef3 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.06358, 0.3331, 0.8878, 0.7888, 1.465, 2.17, 3.369, 5.211};
    private static double[] zeta1 = new double[]{0.0, 0.5288, 0.3379, 0.1912, 0.139, 0.1059, 0.0884, 0.0767, 0.0669, 0.0608, 0.0549, 0.0496, 0.0449, 0.0411, 0.0382, 0.0358, 0.0335, 0.0315, 0.0296};
    private static double[] zeta2 = new double[]{0.0, 1.0, 1.0, 0.9992, 0.6945, 0.53, 0.548, 0.4532, 0.3974, 0.3994, 0.3447, 0.2511, 0.215, 0.1874, 0.1654, 0.1509, 0.1369, 0.1259, 0.1168};
    private static double[] zeta3 = new double[]{0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0236, 0.7753, 0.5962, 0.6995, 0.5851, 0.5149, 0.4974, 0.4412};
    private static double[] dMax = new double[]{0.0, 2.982502423, 2.635120936, 4.144887422, 4.105800759, 3.576656363, 3.872424373, 3.497503547, 3.165369971, 3.204214082, 3.051069564, 4.251312809, 4.503309314, 4.047465141, 4.666024968, 4.265151411, 3.955710076, 4.040067606, 3.776022242};

    @Override
    public float getNoValue() {
        return 100.0f;
    }

    @Override
    public boolean setupCalculation(VolumeDataInterface volumeDataInterface, BS bS, BS bS2, BS[] bSArray, String string, P3[] p3Array, int n, List<int[]> list, float[][] fArray, int[][] nArray, Object object, float[] fArray2, float[] fArray3, boolean bl, float[][] fArray4, float[] fArray5, boolean bl2, P3[] p3Array2, float[] fArray6, int n2) {
        String string2;
        this.useAbsolute = n2 == 2;
        this.bsExcluded = bS2;
        BS bS3 = new BS();
        bS3.or(bS);
        if (bS2 != null) {
            bS3.andNot(bS2);
        }
        this.isPromolecular = n >= 0;
        this.havePoints = p3Array2 != null;
        this.isReducedDensity = bl2;
        if (fArray6 != null) {
            Logger.info("NCI calculation parameters = " + Escape.eAF(fArray6));
        }
        this.type = (int)NciCalculation.getParameter(fArray6, 1, 0.0, "type");
        if (this.type != 0 && bSArray == null) {
            this.type = 0;
        }
        this.rhoMin = NciCalculation.getParameter(fArray6, 2, 1.0E-5, "rhoMin");
        this.rhoPlot = NciCalculation.getParameter(fArray6, 3, this.isPromolecular ? this.DEFAULT_RHOPLOT_PRO : this.DEFAULT_RHOPLOT_SCF, "rhoPlot");
        this.rhoParam = NciCalculation.getParameter(fArray6, 4, this.DEFAULT_RHOPARAM, "rhoParam");
        this.dataScaling = (float)NciCalculation.getParameter(fArray6, 5, 1.0, "dataScaling");
        this.dataIsReducedDensity = this.type < 0;
        switch (this.type) {
            default: {
                this.type = 0;
                string2 = "all";
                bSArray = null;
                break;
            }
            case -1: 
            case 1: {
                this.type = 1;
                string2 = "intramolecular";
                break;
            }
            case -2: 
            case 2: {
                this.type = 2;
                string2 = "intermolecular";
                break;
            }
            case 3: {
                string2 = "ligand";
            }
        }
        this.nMolecules = 0;
        if (!this.isPromolecular && this.type == 0) {
            p3Array = null;
        }
        Logger.info("NCI calculation type = " + (this.isPromolecular ? "promolecular " : "SCF(CUBE) ") + string2);
        this.voxelData = volumeDataInterface.getVoxelData();
        this.countsXYZ = volumeDataInterface.getVoxelCounts();
        this.initialize(this.countsXYZ[0], this.countsXYZ[1], this.countsXYZ[2], p3Array2);
        if (this.havePoints) {
            this.zMin = 0;
            this.yMin = 0;
            this.xMin = 0;
            this.yMax = this.zMax = p3Array2.length;
            this.xMax = this.zMax;
        }
        this.setupCoordinates(volumeDataInterface.getOriginFloat(), volumeDataInterface.getVolumetricVectorLengths(), bS, p3Array, p3Array2, true);
        if (this.qmAtoms != null) {
            int[] nArray2 = new int[bS.length()];
            int n3 = this.qmAtoms.length;
            while (--n3 >= 0) {
                nArray2[this.qmAtoms[n3].index] = n3;
                if (this.qmAtoms[n3].znuc < 1) {
                    this.qmAtoms[n3] = null;
                    continue;
                }
                if (this.qmAtoms[n3].znuc <= 18) continue;
                this.qmAtoms[n3].znuc = 18;
                Logger.info("NCI calculation just setting nuclear charge for " + this.qmAtoms[n3].atom + " to 18 (argon)");
            }
            this.nMolecules = 0;
            if (this.type != 0) {
                for (n3 = 0; n3 < bSArray.length; ++n3) {
                    BS bS4 = BSUtil.copy(bSArray[n3]);
                    bS4.and(bS);
                    if (bS4.nextSetBit(0) < 0) continue;
                    int n4 = bS4.nextSetBit(0);
                    while (n4 >= 0) {
                        this.qmAtoms[nArray2[n4]].iMolecule = this.nMolecules;
                        n4 = bS4.nextSetBit(n4 + 1);
                    }
                    ++this.nMolecules;
                    Logger.info("Molecule " + this.nMolecules + " (" + bS4.cardinality() + " atoms): " + Escape.eBS(bS4));
                }
                this.rhoMolecules = new double[this.nMolecules];
            }
            if (this.nMolecules == 0) {
                this.nMolecules = 1;
            }
            if (this.nMolecules == 1) {
                this.noValuesAtAll = this.type != 0 && this.type != 1;
                this.type = 0;
            }
            if (!this.isPromolecular) {
                this.getBsOK();
            }
        }
        if (!this.isReducedDensity || !this.isPromolecular) {
            this.initializeEigen();
        }
        this.doDebug = Logger.debugging;
        return true;
    }

    private static double getParameter(float[] fArray, int n, double d, String string) {
        double d2 = fArray == null || fArray.length < n + 1 ? 0.0f : fArray[n];
        if (d2 == 0.0) {
            d2 = d;
        }
        Logger.info("NCI calculation parameters[" + n + "] (" + string + ") = " + d2);
        return d2;
    }

    private void getBsOK() {
        if (this.noValuesAtAll || this.nMolecules == 1) {
            return;
        }
        this.bsOK = BSUtil.newBitSet(this.nX * this.nY * this.nZ);
        this.setXYZBohr(null);
        int n = 0;
        for (int i = 0; i < this.countsXYZ[0]; ++i) {
            for (int j = 0; j < this.countsXYZ[1]; ++j) {
                for (int k = 0; k < this.countsXYZ[2]; ++k) {
                    this.processAtoms(i, j, k, n);
                    ++n;
                }
            }
        }
        Logger.info("NCI calculation SCF " + (this.type == 1 ? "intra" : "inter") + "molecular grid points = " + this.bsOK.cardinality());
    }

    @Override
    public void createCube() {
        this.setXYZBohr(this.points);
        this.process();
    }

    @Override
    protected void initializeOnePoint() {
        if (this.eigen == null) {
            this.initializeEigen();
        }
        this.isReducedDensity = false;
        this.initializeOnePointQC();
    }

    private void initializeEigen() {
        this.eigen = new Eigen().set(3);
        this.hess = new double[3][3];
    }

    @Override
    public void getPlane(int n, float[] fArray) {
        if (this.noValuesAtAll) {
            for (int i = 0; i < this.yzCount; ++i) {
                fArray[i] = Float.NaN;
            }
            return;
        }
        this.isReducedDensity = true;
        this.initialize(this.countsXYZ[0], this.countsXYZ[1], this.countsXYZ[2], null);
        this.setXYZBohr(null);
        int n2 = n * this.yzCount;
        int n3 = 0;
        for (int i = 0; i < this.countsXYZ[1]; ++i) {
            for (int j = 0; j < this.countsXYZ[2]; ++j) {
                fArray[n3] = this.bsOK == null || this.bsOK.get(n2 + n3) ? this.getValue(this.processAtoms(n, i, j, -1), this.isReducedDensity) : Float.NaN;
                ++n3;
            }
        }
    }

    @Override
    protected void process() {
        if (this.noValuesAtAll) {
            return;
        }
        int n = this.xMax;
        while (--n >= this.xMin) {
            for (int i = this.yMin; i < this.yMax; ++i) {
                this.vd = this.voxelData[n][this.havePoints ? 0 : i];
                for (int j = this.zMin; j < this.zMax; ++j) {
                    this.vd[this.havePoints ? 0 : j] = this.getValue(this.processAtoms(n, i, j, -1), this.isReducedDensity);
                }
            }
        }
    }

    private float getValue(double d, boolean bl) {
        double d2;
        if (d == 100.0) {
            return Float.NaN;
        }
        if (bl) {
            d2 = c * this.grad * Math.pow(d, rpower);
        } else if (this.useAbsolute) {
            d2 = d;
        } else {
            this.hess[0][0] = this.gxxTemp;
            double d3 = this.gxyTemp;
            this.hess[0][1] = d3;
            this.hess[1][0] = d3;
            double d4 = this.gxzTemp;
            this.hess[0][2] = d4;
            this.hess[2][0] = d4;
            this.hess[1][1] = this.gyyTemp;
            double d5 = this.gyzTemp;
            this.hess[2][1] = d5;
            this.hess[1][2] = d5;
            this.hess[2][2] = this.gzzTemp;
            this.eigen.calc(this.hess);
            double d6 = this.eigen.getRealEigenvalues()[1];
            d2 = d6 < 0.0 ? -d : d;
        }
        return (float)d2;
    }

    private double processAtoms(int n, int n2, int n3, int n4) {
        int n5;
        double d = 0.0;
        if (this.isReducedDensity) {
            if (this.isPromolecular) {
                this.gzTemp = 0.0;
                this.gyTemp = 0.0;
                this.gxTemp = 0.0;
            }
            if (this.type != 0) {
                n5 = this.nMolecules;
                while (--n5 >= 0) {
                    this.rhoMolecules[n5] = 0.0;
                }
            }
        } else {
            this.gxzTemp = 0.0;
            this.gyzTemp = 0.0;
            this.gxyTemp = 0.0;
            this.gzzTemp = 0.0;
            this.gyyTemp = 0.0;
            this.gxxTemp = 0.0;
        }
        n5 = this.qmAtoms.length;
        while (--n5 >= 0) {
            double d2;
            double d3;
            double d4;
            int n6 = this.qmAtoms[n5].znuc;
            double d5 = this.xBohr[n] - this.qmAtoms[n5].x;
            double d6 = this.yBohr[n2] - this.qmAtoms[n5].y;
            double d7 = this.zBohr[n3] - this.qmAtoms[n5].z;
            if (Math.abs(d5) > dMax[n6] || Math.abs(d6) > dMax[n6] || Math.abs(d7) > dMax[n6]) continue;
            double d8 = Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
            double d9 = zeta1[n6];
            double d10 = zeta2[n6];
            double d11 = zeta3[n6];
            double d12 = coef1[n6] * Math.exp(-d8 / d9);
            double d13 = d12 + (d4 = coef2[n6] * Math.exp(-d8 / d10)) + (d3 = coef3[n6] * Math.exp(-d8 / d11));
            if ((d += d13) > this.rhoPlot || d < this.rhoMin) {
                return 100.0;
            }
            if (this.isReducedDensity) {
                if (this.type != 0) {
                    int n7 = this.qmAtoms[n5].iMolecule;
                    this.rhoMolecules[n7] = this.rhoMolecules[n7] + d13;
                }
                if (!this.isPromolecular) continue;
                d2 = (d12 / d9 + d4 / d10 + d3 / d11) / d8;
                this.gxTemp -= d2 * d5;
                this.gyTemp -= d2 * d6;
                this.gzTemp -= d2 * d7;
                continue;
            }
            d2 = (d12 / d9 + d4 / d10 + d3 / d11) / d8;
            double d14 = d2 + (d12 / d9 / d9 + d4 / d10 / d10 + d3 / d11 / d11);
            this.gxxTemp += d14 * (d5 /= d8) * d5 - d2;
            this.gyyTemp += d14 * (d6 /= d8) * d6 - d2;
            this.gzzTemp += d14 * (d7 /= d8) * d7 - d2;
            this.gxyTemp += d14 * d5 * d6;
            this.gxzTemp += d14 * d5 * d7;
            this.gyzTemp += d14 * d6 * d7;
        }
        if (this.isReducedDensity) {
            switch (this.type) {
                case 1: 
                case 2: {
                    n5 = 0;
                    double d15 = this.rhoParam * d;
                    for (int i = 0; i < this.nMolecules; ++i) {
                        if (!(this.rhoMolecules[i] >= d15)) continue;
                        n5 = 1;
                        break;
                    }
                    if ((this.type == 1 ? 1 : 0) != n5) {
                        return 100.0;
                    }
                    if (n4 < 0) break;
                    this.bsOK.set(n4);
                    return 0.0;
                }
                case 3: {
                    break;
                }
            }
            this.grad = this.useAbsolute ? this.gxTemp + this.gyTemp + this.gzTemp : Math.sqrt(this.gxTemp * this.gxTemp + this.gyTemp * this.gyTemp + this.gzTemp * this.gzTemp);
        }
        return d;
    }

    @Override
    public void setPlanes(float[][] fArray) {
        this.yzPlanesRaw = fArray;
        this.yzCount = this.nY * this.nZ;
    }

    @Override
    public void calcPlane(int n, float[] fArray) {
        int n2;
        int n3;
        this.yzPlanesRho[0] = this.yzPlanesRho[1];
        this.yzPlanesRho[1] = fArray;
        if (this.noValuesAtAll) {
            for (int i = 0; i < this.yzCount; ++i) {
                fArray[i] = Float.NaN;
            }
            return;
        }
        int n4 = 0;
        if (this.dataIsReducedDensity) {
            this.p1 = fArray;
        } else {
            n4 = this.yzPlanesRho[0] == null ? 0 : 1;
            this.p0 = this.yzPlanesRaw[n4++];
            this.p1 = this.yzPlanesRaw[n4++];
            this.p2 = this.yzPlanesRaw[n4++];
            int n5 = n3 = n4 == 4 ? 3 : 0;
            while (n3 < n4) {
                for (n2 = 0; n2 < this.yzCount; ++n2) {
                    this.yzPlanesRaw[n3][n2] = Math.abs(this.yzPlanesRaw[n3][n2] * this.dataScaling);
                }
                ++n3;
            }
        }
        n3 = n * this.yzCount;
        int n6 = 0;
        for (n2 = 0; n2 < this.nY; ++n2) {
            int n7 = 0;
            while (n7 < this.nZ) {
                double d = this.p1[n6];
                if (this.bsOK != null && !this.bsOK.get(n3 + n6)) {
                    fArray[n6] = Float.NaN;
                } else if (!this.dataIsReducedDensity) {
                    if (d == 0.0) {
                        fArray[n6] = 0.0f;
                    } else if (d > this.rhoPlot || d < this.rhoMin || n2 == 0 || n2 == this.nY - 1 || n7 == 0 || n7 == this.nZ - 1) {
                        fArray[n6] = Float.NaN;
                    } else {
                        this.gxTemp = (this.p2[n6] - this.p0[n6]) / (2.0f * this.stepBohr[0]);
                        this.gyTemp = (this.p1[n6 + this.nZ] - this.p1[n6 - this.nZ]) / (2.0f * this.stepBohr[1]);
                        this.gzTemp = (this.p1[n6 + 1] - this.p1[n6 - 1]) / (2.0f * this.stepBohr[2]);
                        this.grad = Math.sqrt(this.gxTemp * this.gxTemp + this.gyTemp * this.gyTemp + this.gzTemp * this.gzTemp);
                        fArray[n6] = this.getValue(d, true);
                    }
                }
                ++n7;
                ++n6;
            }
        }
    }

    @Override
    public float process(int n, int n2, float f) {
        double d = this.getPlaneValue(n);
        double d2 = this.getPlaneValue(n2);
        return (float)(d + (double)f * (d2 - d));
    }

    private double getPlaneValue(int n) {
        int n2 = n % this.yzCount;
        int n3 = n / this.yzCount;
        int n4 = n2 / this.nZ;
        int n5 = n2 % this.nZ;
        if (n3 == 0 || n3 == this.nX - 1 || n4 == 0 || n4 == this.nY - 1 || n5 == 0 || n5 == this.nZ - 1) {
            return 100.0;
        }
        int n6 = n3 % 2;
        float[] fArray = this.yzPlanesRaw[n6++];
        float[] fArray2 = this.yzPlanesRaw[n6++];
        float[] fArray3 = this.yzPlanesRaw[n6++];
        double d = fArray2[n2];
        if (d > this.rhoPlot || d < this.rhoMin) {
            return 100.0;
        }
        float f = this.stepBohr[0];
        float f2 = this.stepBohr[1];
        float f3 = this.stepBohr[2];
        this.gxxTemp = ((double)fArray3[n2] - 2.0 * d + (double)fArray[n2]) / (double)(f * f);
        this.gyyTemp = ((double)fArray2[n2 + this.nZ] - 2.0 * d + (double)fArray2[n2 - this.nZ]) / (double)(f2 * f2);
        this.gzzTemp = ((double)fArray2[n2 + 1] - 2.0 * d + (double)fArray2[n2 - 1]) / (double)(f3 * f3);
        this.gxyTemp = (fArray3[n2 + this.nZ] - fArray3[n2 - this.nZ] - (fArray[n2 + this.nZ] - fArray[n2 - this.nZ])) / (4.0f * f * f2);
        this.gxzTemp = (fArray3[n2 + 1] - fArray3[n2 - 1] - (fArray[n2 + 1] - fArray[n2 - 1])) / (4.0f * f * f3);
        this.gyzTemp = (fArray2[n2 + this.nZ + 1] - fArray2[n2 - this.nZ + 1] - (fArray2[n2 + this.nZ - 1] - fArray2[n2 - this.nZ - 1])) / (4.0f * f2 * f3);
        if (Double.isNaN(this.gxxTemp) || Double.isNaN(this.gyyTemp) || Double.isNaN(this.gzzTemp) || Double.isNaN(this.gxyTemp) || Double.isNaN(this.gxzTemp) || Double.isNaN(this.gyzTemp)) {
            return Double.NaN;
        }
        return this.getValue(d, false);
    }
}

