/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;

public final class Chain {
    public Model model;
    public int chainID;
    public int index;
    public boolean isDna;
    public boolean isRna;
    int groupCount;
    Group[] groups = new Group[16];
    int selectedGroupCount;

    public Atom getAtom(int n) {
        return this.model.modelSet.atoms[n];
    }

    Chain(Model model, int n, int n2) {
        this.model = model;
        this.chainID = n;
        this.index = n2;
    }

    public Group getGroup(int n) {
        return this.groups[n];
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    void calcSelectedGroupsCount(BS bS) {
        this.selectedGroupCount = 0;
        for (int i = 0; i < this.groupCount; ++i) {
            int n;
            Group group = this.groups[i];
            if (this.groups[i].isSelected(bS)) {
                int n2 = this.selectedGroupCount;
                n = n2;
                this.selectedGroupCount = n2 + 1;
            } else {
                n = -1;
            }
            group.selectedIndex = n;
        }
    }

    public int selectSeqcodeRange(int n, int n2, int n3, BS bS) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl = false;
        for (n8 = n; n8 < this.groupCount && this.groups[n8].seqcode != n2; ++n8) {
        }
        if (n8 == this.groupCount) {
            if (n > 0) {
                return -1;
            }
            bl = true;
            n7 = Integer.MAX_VALUE;
            n6 = this.groupCount;
            while (--n6 >= 0) {
                n5 = this.groups[n6].seqcode;
                if (n5 <= n2 || n5 - n2 >= n7) continue;
                n8 = n6;
                n7 = n5 - n2;
            }
            if (n7 == Integer.MAX_VALUE) {
                return -1;
            }
        }
        if (n3 == Integer.MAX_VALUE) {
            n4 = this.groupCount - 1;
            bl = true;
        } else {
            for (n4 = n8; n4 < this.groupCount && this.groups[n4].seqcode != n3; ++n4) {
            }
            if (n4 == this.groupCount) {
                if (n > 0) {
                    return -1;
                }
                bl = true;
                n7 = Integer.MAX_VALUE;
                for (n6 = n8; n6 < this.groupCount; ++n6) {
                    n5 = this.groups[n6].seqcode;
                    if (n5 >= n3 || n3 - n5 >= n7) continue;
                    n4 = n6;
                    n7 = n3 - n5;
                }
                if (n7 == Integer.MAX_VALUE) {
                    return -1;
                }
            }
        }
        for (n6 = n8; n6 <= n4; ++n6) {
            this.groups[n6].selectAtoms(bS);
        }
        return bl ? -1 : n4 + 1;
    }

    void fixIndices(int n, BS bS) {
        for (int i = 0; i < this.groupCount; ++i) {
            this.groups[i].fixIndices(n, bS);
        }
    }

    void setAtomBitSet(BS bS) {
        for (int i = 0; i < this.groupCount; ++i) {
            this.groups[i].selectAtoms(bS);
        }
    }

    public String getIDStr() {
        return this.chainID == 0 ? "" : (this.chainID < 256 ? "" + (char)this.chainID : (String)this.model.modelSet.viewer.chainMap.get(this.chainID));
    }
}

