/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.io.IOException;
import javajs.util.OC;
import javajs.util.PT;
import org.jmol.api.Interface;
import org.jmol.api.JmolDocument;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.SurfaceReader;

abstract class SurfaceFileReader
extends SurfaceReader {
    protected BufferedReader br;
    protected JmolDocument binarydoc;
    protected OC out;
    protected String line;
    protected int[] next = new int[1];

    SurfaceFileReader() {
    }

    @Override
    void init(SurfaceGenerator surfaceGenerator) {
        this.initSR(surfaceGenerator);
    }

    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2SFR(surfaceGenerator, bufferedReader);
    }

    void init2SFR(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init(surfaceGenerator);
        this.br = bufferedReader;
    }

    JmolDocument newBinaryDocument() {
        return (JmolDocument)Interface.getOptionInterface("io2.BinaryDocument");
    }

    @Override
    protected void setOutputChannel(OC oC) {
        if (this.binarydoc == null) {
            this.out = oC;
        } else {
            this.sg.setOutputChannel(this.binarydoc, oC);
        }
    }

    @Override
    protected void closeReader() {
        this.closeReaderSFR();
    }

    protected void closeReaderSFR() {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.out != null) {
            this.out.closeChannel();
        }
        if (this.binarydoc != null) {
            this.binarydoc.close();
        }
    }

    @Override
    void discardTempData(boolean bl) {
        this.closeReader();
        this.discardTempDataSR(bl);
    }

    protected String[] getTokens() {
        return PT.getTokensAt(this.line, 0);
    }

    protected float parseFloat() {
        return PT.parseFloatNext(this.line, this.next);
    }

    protected float parseFloatStr(String string) {
        this.next[0] = 0;
        return PT.parseFloatNext(string, this.next);
    }

    protected float parseFloatRange(String string, int n, int n2) {
        this.next[0] = n;
        return PT.parseFloatRange(string, n2, this.next);
    }

    protected int parseInt() {
        return PT.parseIntNext(this.line, this.next);
    }

    protected int parseIntStr(String string) {
        this.next[0] = 0;
        return PT.parseIntNext(string, this.next);
    }

    protected int parseIntNext(String string) {
        return PT.parseIntNext(string, this.next);
    }

    protected float[] parseFloatArrayStr(String string) {
        this.next[0] = 0;
        return PT.parseFloatArrayNext(string, this.next, null, null, null);
    }

    protected float[] parseFloatArray(float[] fArray, String string, String string2) {
        return PT.parseFloatArrayNext(this.line, this.next, fArray, string, string2);
    }

    protected String getQuotedStringNext() {
        return PT.getQuotedStringNext(this.line, this.next);
    }

    protected void skipTo(String string, String string2) throws Exception {
        if (string != null) {
            while (this.readLine().indexOf(string) < 0) {
            }
        }
        if (string2 != null) {
            this.next[0] = this.line.indexOf(string2) + string2.length() + 2;
        }
    }

    protected String readLine() throws Exception {
        this.line = this.br.readLine();
        if (this.line != null) {
            this.nBytes += (long)this.line.length();
            if (this.out != null) {
                byte[] byArray = this.line.getBytes();
                this.out.write(byArray, 0, byArray.length);
                this.out.writeByteAsInt(10);
            }
        }
        return this.line;
    }
}

