/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.image;

import java.util.Map;
import javajs.api.GenericPlatform;
import javajs.util.OC;
import org.jmol.api.JmolImageEncoder;

public abstract class ImageEncoder
implements JmolImageEncoder {
    protected OC out;
    protected int width = -1;
    protected int height = -1;
    protected int quality = -1;
    protected String date;
    protected String[] errRet;
    protected int[] pixels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createImage(GenericPlatform genericPlatform, String string, Object object, OC oC, Map<String, Object> map, String[] stringArray) {
        this.out = oC;
        this.errRet = stringArray;
        try {
            this.width = genericPlatform.getImageWidth(object);
            this.height = genericPlatform.getImageHeight(object);
            this.date = (String)map.get("date");
            Integer n = (Integer)map.get("quality");
            this.quality = n == null ? -1 : n;
            this.setParams(map);
            this.encodeImage(genericPlatform, object);
            this.generate();
        }
        catch (Exception exception) {
            stringArray[0] = exception.toString();
            oC.cancel();
        }
        finally {
            this.close();
        }
        return stringArray[0] == null;
    }

    protected abstract void setParams(Map<String, Object> var1);

    protected abstract void generate() throws Exception;

    protected void encodeImage(GenericPlatform genericPlatform, Object object) throws Exception {
        this.pixels = new int[this.width * this.height];
        this.pixels = genericPlatform.grabPixels(object, this.width, this.height, this.pixels, 0, this.height);
    }

    protected void putString(String string) {
        this.out.append(string);
    }

    protected void putByte(int n) {
        this.out.writeByteAsInt(n);
    }

    protected void close() {
        this.out.closeChannel();
    }
}

