/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class XcrysdenReader
extends AtomSetCollectionReader {
    private int nAtoms;
    private boolean animation = false;
    private float[] unitCellData = new float[9];
    private int animationStep;

    @Override
    protected void initializeReader() throws Exception {
        this.doApplySymmetry = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.contains("ANIMSTEP")) {
            this.readNostep();
        } else if (this.line.contains("CRYSTAL")) {
            this.setFractionalCoordinates(false);
        } else if (this.line.contains("PRIMVEC")) {
            this.readUnitCell();
        } else if (this.line.contains("PRIMCOORD")) {
            this.readCoordinates();
        }
        return true;
    }

    private void readNostep() throws Exception {
        this.animation = true;
    }

    private void readUnitCell() throws Exception {
        this.setSymmetry();
        this.fillFloatArray(null, 0, this.unitCellData);
        this.setUnitCell();
    }

    private void setUnitCell() {
        this.addPrimitiveLatticeVector(0, this.unitCellData, 0);
        this.addPrimitiveLatticeVector(1, this.unitCellData, 3);
        this.addPrimitiveLatticeVector(2, this.unitCellData, 6);
    }

    private void setSymmetry() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.atomSetCollection.newAtomSet();
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(false);
    }

    private void readCoordinates() throws Exception {
        String[] stringArray = XcrysdenReader.getTokensStr(this.readLine());
        this.nAtoms = Integer.parseInt(stringArray[0]);
        this.setFractionalCoordinates(false);
        for (int i = 0; i < this.nAtoms && this.readLine() != null; ++i) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray2 = this.getTokens();
            atom.atomName = XcrysdenReader.getElementSymbol(Integer.parseInt(stringArray2[0]));
            float f = this.parseFloatStr(stringArray2[1]);
            float f2 = this.parseFloatStr(stringArray2[2]);
            float f3 = this.parseFloatStr(stringArray2[3]);
            this.setAtomCoordXYZ(atom, f, f2, f3);
        }
        this.atomSetCollection.setAtomSetName(this.animation ? "Structure " + this.animationStep++ : "Initial coordinates");
    }
}

