/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

abstract class BasisFunctionReader
extends AtomSetCollectionReader {
    protected List<int[]> shells;
    protected Map<String, Object> moData = new Hashtable<String, Object>();
    protected List<Map<String, Object>> orbitals = new List();
    protected int nOrbitals = 0;
    protected boolean ignoreMOs = false;
    protected String alphaBeta = "";
    protected int[][] dfCoefMaps;
    private String[] filterTokens;
    private boolean filterIsNot;
    protected static String CANONICAL_DC_LIST = "DXX   DYY   DZZ   DXY   DXZ   DYZ";
    protected static String CANONICAL_FC_LIST = "XXX   YYY   ZZZ   XYY   XXY   XXZ   XZZ   YZZ   YYZ   XYZ";
    protected static String CANONICAL_DS_LIST = "d0    d1+   d1-   d2+   d2-";
    protected static String CANONICAL_FS_LIST = "f0    f1+   f1-   f2+   f2-   f3+   f3-";
    protected int nCoef;

    BasisFunctionReader() {
    }

    protected boolean filterMO() {
        boolean bl;
        boolean bl2 = bl = this.line.indexOf(10) == 0;
        if (!bl && !this.doReadMolecularOrbitals) {
            return false;
        }
        if (this.filter == null) {
            return true;
        }
        boolean bl3 = true;
        int n = 0;
        this.line = this.line + " " + this.alphaBeta;
        String string = this.line.toUpperCase();
        if (this.filterTokens == null) {
            this.filterIsNot = this.filter.indexOf("!") >= 0;
            this.filterTokens = BasisFunctionReader.getTokensStr(this.filter.replace('!', ' ').replace(',', ' ').replace(';', ' '));
        }
        for (int i = 0; i < this.filterTokens.length; ++i) {
            if (string.indexOf(this.filterTokens[i]) >= 0) {
                if (this.filterIsNot) continue;
                n = this.filterTokens.length;
                break;
            }
            if (!this.filterIsNot) continue;
            ++n;
        }
        boolean bl4 = bl3 = n == this.filterTokens.length;
        if (!bl) {
            Logger.info("filter MOs: " + bl3 + " for \"" + this.line + "\"");
        }
        return bl3;
    }

    protected void setMO(Map<String, Object> map) {
        if (this.dfCoefMaps != null) {
            map.put("dfCoefMaps", this.dfCoefMaps);
        }
        this.orbitals.addLast(map);
    }

    protected boolean isQuantumBasisSupported(char c) {
        return "SPLDF".indexOf(Character.toUpperCase(c)) >= 0;
    }

    protected boolean getDFMap(String string, int n, String string2, int n2) {
        if (string.equals(string2)) {
            return true;
        }
        this.getDfCoefMaps();
        String[] stringArray = BasisFunctionReader.getTokensStr(string);
        boolean bl = true;
        for (int i = 0; i < this.dfCoefMaps[n].length && bl; ++i) {
            int n3;
            String string3 = stringArray[i];
            if (string3.length() >= n2 && (n3 = string2.indexOf(string3)) >= 0) {
                this.dfCoefMaps[n][n3 /= 6] = i - n3;
                continue;
            }
            bl = false;
        }
        if (!bl) {
            Logger.error("Disabling orbitals of type " + n + " -- Cannot read orbital order for: " + string + "\n expecting: " + string2);
            this.dfCoefMaps[n][0] = Integer.MIN_VALUE;
        }
        return bl;
    }

    protected int[][] getDfCoefMaps() {
        if (this.dfCoefMaps == null) {
            this.dfCoefMaps = JmolAdapter.getNewDfCoefMap();
        }
        return this.dfCoefMaps;
    }

    protected static final String canonicalizeQuantumSubshellTag(String string) {
        char c = string.charAt(0);
        if (c == 'X' || c == 'Y' || c == 'Z') {
            char[] cArray = string.toCharArray();
            Arrays.sort(cArray);
            return new String(cArray);
        }
        return string;
    }

    protected int fixSlaterTypes(int n, int n2) {
        if (this.shells == null) {
            return 0;
        }
        this.nCoef = 0;
        int n3 = this.shells.size();
        while (--n3 >= 0) {
            int[] nArray = (int[])this.shells.get(n3);
            if (nArray[1] == n) {
                nArray[1] = n2;
            }
            int n4 = this.getDfCoefMaps()[nArray[1]].length;
            this.nCoef += n4;
        }
        return this.nCoef;
    }

    public class MOEnergySorter
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            float f;
            float f2 = ((Float)((Map)object).get("energy")).floatValue();
            return f2 < (f = ((Float)((Map)object2).get("energy")).floatValue()) ? -1 : (f2 > f ? 1 : 0);
        }
    }
}

