/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.J2SIgnoreImport;
import javajs.J2SRequireImport;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.Txt;

@J2SIgnoreImport(value={Properties.class, BufferedInputStream.class})
@J2SRequireImport(value={SB.class, Txt.class})
public final class JC {
    public static final String copyright = "(C) 2012 Jmol Development";
    public static final String version;
    public static final String date;
    public static final boolean officialRelease = false;
    public static final String DEFAULT_HELP_PATH = "http://chemapps.stolaf.edu/jmol/docs/index.htm";
    public static final String STATE_VERSION_STAMP = "# Jmol state version ";
    public static final String EMBEDDED_SCRIPT_TAG = "**** Jmol Embedded Script ****";
    public static final String NOTE_SCRIPT_FILE = "NOTE: file recognized as a script file: ";
    public static final String SCRIPT_EDITOR_IGNORE = "\u0001## EDITOR_IGNORE ##";
    public static final String REPAINT_IGNORE = "\u0001## REPAINT_IGNORE ##";
    public static final String LOAD_ATOM_DATA_TYPES = ";xyz;vxyz;vibration;temperature;occupancy;partialcharge;";
    public static final float radiansPerDegree = (float)Math.PI / 180;
    public static final String allowedQuaternionFrames = "RC;RP;a;b;c;n;p;q;x;";
    public static final String EXPORT_DRIVER_LIST = "Idtf;Maya;Povray;Vrml;X3d;Tachyon;Obj";
    public static final V3 center;
    public static final V3 axisX;
    public static final V3 axisY;
    public static final V3 axisZ;
    public static final V3 axisNX;
    public static final V3 axisNY;
    public static final V3 axisNZ;
    public static final V3[] unitAxisVectors;
    public static final int XY_ZTOP = 100;
    public static final int DEFAULT_PERCENT_VDW_ATOM = 23;
    public static final float DEFAULT_BOND_RADIUS = 0.15f;
    public static final short DEFAULT_BOND_MILLIANGSTROM_RADIUS = 150;
    public static final float DEFAULT_STRUT_RADIUS = 0.3f;
    public static final float DEFAULT_BOND_TOLERANCE = 0.45f;
    public static final float DEFAULT_MIN_BOND_DISTANCE = 0.4f;
    public static final float DEFAULT_MAX_CONNECT_DISTANCE = 1.0E8f;
    public static final float DEFAULT_MIN_CONNECT_DISTANCE = 0.1f;
    public static final int MINIMIZATION_ATOM_MAX = 200;
    public static final float MINIMIZE_FIXED_RANGE = 5.0f;
    public static final float ENC_CALC_MAX_DIST = 3.0f;
    public static final int ENV_CALC_MAX_LEVEL = 3;
    public static final int LABEL_FRONT_FLAG = 32;
    public static final int LABEL_GROUP_FLAG = 16;
    public static final int LABEL_POINTER_FLAGS = 3;
    public static final int LABEL_ALIGN_FLAGS = 12;
    public static final int LABEL_ZPOS_FLAGS = 48;
    public static final int LABEL_SCALE_FLAG = 64;
    public static final int LABEL_EXACT_OFFSET_FLAG = 128;
    public static final int LABEL_FLAGS = 255;
    public static final int LABEL_FLAG_OFFSET = 8;
    public static final int MOUSE_NONE = -1;
    public static final byte MULTIBOND_NEVER = 0;
    public static final byte MULTIBOND_WIREFRAME = 1;
    public static final byte MULTIBOND_NOTSMALL = 2;
    public static final byte MULTIBOND_ALWAYS = 3;
    public static final int MAXIMUM_AUTO_BOND_COUNT = 20;
    public static final short madMultipleBondSmallMaximum = 500;
    public static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    public static final int[] altArgbsCpk;
    public static final int[] argbsAmino;
    public static final int argbShapelyBackbone = -4671304;
    public static final int argbShapelySpecial = -10616738;
    public static final int argbShapelyDefault = -65281;
    public static final int[] argbsChainAtom;
    public static final int[] argbsChainHetero;
    public static final int[] argbsFormalCharge;
    public static final int[] argbsRwbScale;
    public static final int FORMAL_CHARGE_COLIX_RED;
    public static final int PARTIAL_CHARGE_COLIX_RED;
    public static final int PARTIAL_CHARGE_RANGE_SIZE;
    public static final int[] argbsRoygbScale;
    public static final int argbsIsosurfacePositive = -11525984;
    public static final int argbsIsosurfaceNegative = -6283184;
    private static final String[] specialAtomNames;
    public static final int ATOMID_MAX;
    public static final byte ATOMID_AMINO_NITROGEN = 1;
    public static final byte ATOMID_ALPHA_CARBON = 2;
    public static final byte ATOMID_CARBONYL_CARBON = 3;
    public static final byte ATOMID_CARBONYL_OXYGEN = 4;
    public static final byte ATOMID_O1 = 5;
    public static final int ATOMID_ALPHA_ONLY_MASK = 4;
    public static final int ATOMID_PROTEIN_MASK = 14;
    public static final byte ATOMID_O5_PRIME = 6;
    public static final byte ATOMID_C4_PRIME = 8;
    public static final byte ATOMID_C3_PRIME = 9;
    public static final byte ATOMID_O3_PRIME = 10;
    public static final byte ATOMID_C1_PRIME = 12;
    public static final int ATOMID_NUCLEIC_MASK = 8128;
    public static final byte ATOMID_NUCLEIC_PHOSPHORUS = 13;
    public static final int ATOMID_PHOSPHORUS_ONLY_MASK = 8192;
    public static final int ATOMID_DISTINGUISHING_ATOM_MAX = 14;
    public static final byte ATOMID_CARBONYL_OD1 = 14;
    public static final byte ATOMID_CARBONYL_OD2 = 15;
    public static final byte ATOMID_CARBONYL_OE1 = 16;
    public static final byte ATOMID_CARBONYL_OE2 = 17;
    public static final byte ATOMID_SG = 18;
    public static final byte ATOMID_N1 = 32;
    public static final byte ATOMID_C2 = 33;
    public static final byte ATOMID_N3 = 34;
    public static final byte ATOMID_C4 = 35;
    public static final byte ATOMID_C5 = 36;
    public static final byte ATOMID_C6 = 37;
    public static final byte ATOMID_O2 = 38;
    public static final byte ATOMID_N7 = 39;
    public static final byte ATOMID_C8 = 40;
    public static final byte ATOMID_N9 = 41;
    public static final byte ATOMID_N4 = 42;
    public static final byte ATOMID_N2 = 43;
    public static final byte ATOMID_N6 = 44;
    public static final byte ATOMID_C5M = 45;
    public static final byte ATOMID_O6 = 46;
    public static final byte ATOMID_O4 = 47;
    public static final byte ATOMID_S4 = 48;
    public static final byte ATOMID_C7 = 49;
    public static final byte ATOMID_TERMINATING_OXT = 64;
    public static final byte ATOMID_H5T_TERMINUS = 72;
    public static final byte ATOMID_O5T_TERMINUS = 73;
    public static final byte ATOMID_O1P = 74;
    public static final byte ATOMID_OP1 = 75;
    public static final byte ATOMID_O2P = 76;
    public static final byte ATOMID_OP2 = 77;
    public static final byte ATOMID_O2_PRIME = 79;
    public static final byte ATOMID_H3T_TERMINUS = 88;
    public static final byte ATOMID_HO3_PRIME = 89;
    public static final byte ATOMID_HO5_PRIME = 90;
    private static Map<String, Integer> htSpecialAtoms;
    public static final int GROUPID_ARGININE = 2;
    public static final int GROUPID_ASPARAGINE = 3;
    public static final int GROUPID_ASPARTATE = 4;
    public static final int GROUPID_CYSTEINE = 5;
    public static final int GROUPID_GLUTAMINE = 6;
    public static final int GROUPID_GLUTAMATE = 7;
    public static final int GROUPID_HISTIDINE = 9;
    public static final int GROUPID_LYSINE = 12;
    public static final int GROUPID_PROLINE = 15;
    public static final int GROUPID_TRYPTOPHAN = 19;
    public static final int GROUPID_AMINO_MAX = 24;
    public static final int GROUPID_NUCLEIC_MAX = 42;
    private static final int GROUPID_WATER = 42;
    private static final int GROUPID_SOLVENT_MIN = 45;
    private static final int GROUPID_ION_MIN = 46;
    private static final int GROUPID_ION_MAX = 48;
    public static final String[] predefinedGroup3Names;
    private static final String naNoH = "A3;A1;C3;G3;I3";
    private static final String aaSp2 = "ARGN;ASNN;ASNO;ASPO;GLNN;GLNO;GLUO;HISN;HISC;PHECTRPC;TRPN;TYRC";
    private static final String aaPlus = "LYSN";
    private static final String[] pdbBondInfo;
    private static final int[] pdbHydrogenCount;
    public static final int[] argbsShapely;
    private static final String allCarbohydrates = ",[AHR],[ALL],[AMU],[ARA],[ARB],[BDF],[BDR],[BGC],[BMA],[FCA],[FCB],[FRU],[FUC],[FUL],[GAL],[GLA],[GLC],[GXL],[GUP],[LXC],[MAN],[RAM],[RIB],[RIP],[XYP],[XYS],[CBI],[CT3],[CTR],[CTT],[LAT],[MAB],[MAL],[MLR],[MTT],[SUC],[TRE],[GCU],[MTL],[NAG],[NDG],[RHA],[SOR],[SOL],[SOE],[XYL],[A2G],[LBT],[NGA],[SIA],[SLB],[AFL],[AGC],[GLB],[NAN],[RAA]";
    private static String group3List;
    private static int group3Count;
    public static final char[] predefinedGroup1Names;
    public static String[] predefinedVariable;
    public static String[] predefinedStatic;
    public static String[] databases;
    public static final String MODELKIT_ZAP_STRING = "5\n\nC 0 0 0\nH .63 .63 .63\nH -.63 -.63 .63\nH -.63 .63 -.63\nH .63 -.63 -.63";
    public static final String MODELKIT_ZAP_TITLE = "Jmol Model Kit";
    public static final String ADD_HYDROGEN_TITLE = "Viewer.AddHydrogens";
    public static final String DEFAULT_FONTFACE = "SansSerif";
    public static final String DEFAULT_FONTSTYLE = "Plain";
    public static final int LABEL_MINIMUM_FONTSIZE = 6;
    public static final int LABEL_MAXIMUM_FONTSIZE = 63;
    public static final int LABEL_DEFAULT_FONTSIZE = 13;
    public static final int LABEL_DEFAULT_X_OFFSET = 4;
    public static final int LABEL_DEFAULT_Y_OFFSET = 4;
    public static final int MEASURE_DEFAULT_FONTSIZE = 15;
    public static final int AXES_DEFAULT_FONTSIZE = 14;
    public static final int SHAPE_BALLS = 0;
    public static final int SHAPE_STICKS = 1;
    public static final int SHAPE_HSTICKS = 2;
    public static final int SHAPE_SSSTICKS = 3;
    public static final int SHAPE_STRUTS = 4;
    public static final int SHAPE_LABELS = 5;
    public static final int SHAPE_MEASURES = 6;
    public static final int SHAPE_STARS = 7;
    public static final int SHAPE_HALOS = 8;
    public static final int SHAPE_MIN_SECONDARY = 9;
    public static final int SHAPE_BACKBONE = 9;
    public static final int SHAPE_TRACE = 10;
    public static final int SHAPE_CARTOON = 11;
    public static final int SHAPE_STRANDS = 12;
    public static final int SHAPE_MESHRIBBON = 13;
    public static final int SHAPE_RIBBONS = 14;
    public static final int SHAPE_ROCKETS = 15;
    public static final int SHAPE_MAX_SECONDARY = 16;
    public static final int SHAPE_MIN_SPECIAL = 16;
    public static final int SHAPE_DOTS = 16;
    public static final int SHAPE_DIPOLES = 17;
    public static final int SHAPE_VECTORS = 18;
    public static final int SHAPE_GEOSURFACE = 19;
    public static final int SHAPE_ELLIPSOIDS = 20;
    public static final int SHAPE_MAX_SIZE_ZERO_ON_RESTRICT = 21;
    public static final int SHAPE_POLYHEDRA = 21;
    public static final int SHAPE_MIN_HAS_ID = 22;
    public static final int SHAPE_MIN_MESH_COLLECTION = 22;
    public static final int SHAPE_DRAW = 22;
    public static final int SHAPE_MAX_SPECIAL = 23;
    public static final int SHAPE_CGO = 23;
    public static final int SHAPE_MIN_SURFACE = 24;
    public static final int SHAPE_ISOSURFACE = 24;
    public static final int SHAPE_CONTACT = 25;
    public static final int SHAPE_LCAOCARTOON = 26;
    public static final int SHAPE_MO = 27;
    public static final int SHAPE_PMESH = 28;
    public static final int SHAPE_PLOT3D = 29;
    public static final int SHAPE_MAX_SURFACE = 29;
    public static final int SHAPE_MAX_MESH_COLLECTION = 29;
    public static final int SHAPE_ECHO = 30;
    public static final int SHAPE_MAX_HAS_ID = 31;
    public static final int SHAPE_AXES = 31;
    public static final int SHAPE_BBCAGE = 32;
    public static final int SHAPE_UCCAGE = 33;
    public static final int SHAPE_HOVER = 34;
    public static final int SHAPE_FRANK = 35;
    public static final int SHAPE_MAX = 36;
    public static final String[] shapeClassBases;
    public static final int ATOM_IN_FRAME = 1;
    public static final int ATOM_SLABBED = 2;
    public static final String binaryExtensions = ";pse=PyMOL;";
    public static final String SCRIPT_COMPLETED = "Script completed";
    public static final String JPEG_EXTENSIONS = ";jpg;jpeg;jpg64;jpeg64;";
    public static final String IMAGE_TYPES = ";jpg;jpeg;jpg64;jpeg64;gif;pdf;ppm;png;pngj;pngt;";
    public static final String IMAGE_OR_SCENE = ";jpg;jpeg;jpg64;jpeg64;gif;pdf;ppm;png;pngj;pngt;scene;";
    public static final String[] hAlignNames;
    public static final String[] vAlignNames;
    public static final int POINTER_NONE = 0;
    public static final int POINTER_ON = 1;
    public static final int POINTER_BACKGROUND = 2;
    public static final int VALIGN_XY = 0;
    public static final int VALIGN_TOP = 1;
    public static final int VALIGN_BOTTOM = 2;
    public static final int VALIGN_MIDDLE = 3;
    public static final int VALIGN_XYZ = 4;
    public static final int ALIGN_NONE = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_RIGHT = 3;

    public static String embedScript(String string) {
        return "\n/****** Jmol Embedded Script **** \n" + string + "\n**/";
    }

    public static final String getSpecialAtomName(int n) {
        return specialAtomNames[n];
    }

    private static void getSpecialAtomNames() {
        htSpecialAtoms = new Hashtable<String, Integer>();
        int n = specialAtomNames.length;
        while (--n >= 0) {
            String string = specialAtomNames[n];
            if (string == null) continue;
            htSpecialAtoms.put(string, n);
        }
    }

    public static byte lookupSpecialAtomID(String string) {
        Integer n;
        if (htSpecialAtoms == null) {
            JC.getSpecialAtomNames();
        }
        if ((n = htSpecialAtoms.get(string)) != null) {
            return (byte)n.intValue();
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean getAminoAcidValenceAndCharge(String string, String string2, int[] nArray) {
        if (string == null) return false;
        if (string.length() == 0) return false;
        if (string.length() > 3) return false;
        if (string2.equals("CA")) return false;
        if (string2.equals("CB")) {
            return false;
        }
        char c = string2.charAt(0);
        char c2 = string2.length() == 1 ? (char)'\u0000' : string2.charAt(1);
        boolean bl = false;
        int n = nArray[3];
        block0 : switch (string.length()) {
            case 3: {
                if (string2.length() == 1) {
                    switch (c) {
                        case 'N': {
                            if (n > 1) {
                                return false;
                            }
                            nArray[1] = 1;
                            break block0;
                        }
                        case 'O': {
                            bl = "HOH;DOD;WAT".indexOf(string) < 0;
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                String string3 = string + c;
                boolean bl2 = bl = aaSp2.indexOf(string3) >= 0;
                if (aaPlus.indexOf(string3) >= 0) {
                    nArray[1] = 1;
                    break;
                }
                if (c != 'O' || c2 != 'X') break;
                nArray[1] = -1;
                break;
            }
            case 1: 
            case 2: {
                if (string2.length() > 2 && string2.charAt(2) == '\'') {
                    return false;
                }
                switch (c) {
                    case 'C': {
                        if (c2 != '7') break;
                        return false;
                    }
                    case 'N': {
                        switch (c2) {
                            case '1': 
                            case '3': {
                                if (naNoH.indexOf("" + string.charAt(string.length() - 1) + c2) < 0) break;
                                nArray[0] = nArray[0] - 1;
                                break;
                            }
                            case '7': {
                                nArray[0] = nArray[0] - 1;
                            }
                        }
                        break;
                    }
                }
                bl = true;
                break;
            }
        }
        if (!bl) return true;
        switch (c) {
            case 'N': {
                nArray[2] = 2;
                return true;
            }
            case 'C': {
                nArray[2] = 2;
                nArray[0] = nArray[0] - 1;
                return true;
            }
            case 'O': {
                nArray[0] = nArray[0] - 1;
                return true;
            }
        }
        return true;
    }

    public static int getStandardPdbHydrogenCount(int n) {
        return n < 0 || n >= pdbHydrogenCount.length ? -1 : pdbHydrogenCount[n];
    }

    public static String[][] getPdbBondInfo(int n, boolean bl) {
        if (n < 0 || n > pdbBondInfo.length) {
            return null;
        }
        String string = pdbBondInfo[n];
        if (bl && (n = string.indexOf("O3'")) >= 0) {
            string = string.substring(0, n);
        }
        String[] stringArray = PT.getTokens(string);
        String[][] stringArray2 = new String[stringArray.length / 2][];
        int n2 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string2;
            String string3 = stringArray[n2++];
            if ((string2 = stringArray[n2++]).length() == 1) {
                switch (string2.charAt(0)) {
                    case 'N': {
                        string2 = "H@H2";
                        break;
                    }
                    case 'B': {
                        string2 = "HB3@HB2";
                        break;
                    }
                    case 'D': {
                        string2 = "HD2@HD3";
                        break;
                    }
                    case 'G': {
                        string2 = "HG3@HG2";
                        break;
                    }
                    case '2': {
                        string2 = "H2''@H2'";
                        break;
                    }
                    case '5': {
                        string2 = "H5''@H5'";
                    }
                }
            }
            if (string2.charAt(0) != 'H' && string3.compareTo(string2) > 0) {
                string = string2;
                string2 = string3;
                string3 = string;
            }
            stringArray2[i] = new String[]{string3, string2, string2.startsWith("H") ? "1" : "2"};
        }
        return stringArray2;
    }

    public static final boolean checkCarbohydrate(String string) {
        return string != null && allCarbohydrates.indexOf("[" + string.toUpperCase() + "]") >= 0;
    }

    public static String getGroup3List() {
        if (group3List != null) {
            return group3List;
        }
        SB sB = new SB();
        for (int i = 1; i < 42; ++i) {
            sB.append(",[").append((predefinedGroup3Names[i] + "   ").substring(0, 3) + "]");
        }
        sB.append(allCarbohydrates);
        group3Count = sB.length() / 6;
        group3List = sB.toString();
        return group3List;
    }

    public static final boolean isHetero(String string) {
        return JC.getGroup3Pt(string) >= 42;
    }

    private static int getGroup3Pt(String string) {
        JC.getGroup3List();
        SB sB = new SB().append("[");
        sB.append(string);
        switch (string.length()) {
            case 1: {
                sB.append("  ");
                break;
            }
            case 2: {
                sB.append(" ");
            }
        }
        int n = group3List.indexOf(sB.toString());
        return n < 0 ? Integer.MAX_VALUE : n / 6 + 1;
    }

    public static int getGroup3Count() {
        if (group3Count > 0) {
            return group3Count;
        }
        JC.getGroup3List();
        group3Count = group3List.length() / 6;
        return group3Count;
    }

    public static final boolean isShapeSecondary(int n) {
        return n >= 9 && n < 16;
    }

    public static final int shapeTokenIndex(int n) {
        switch (n) {
            case 0x40000024: 
            case 0x44100001: {
                return 0;
            }
            case 659488: 
            case 1678770178: {
                return 1;
            }
            case 1612189718: {
                return 2;
            }
            case 1611141176: {
                return 3;
            }
            case 0x1A101A: {
                return 4;
            }
            case 1826248715: {
                return 5;
            }
            case 0x20021010: 
            case 1746538509: {
                return 6;
            }
            case 1113200652: {
                return 7;
            }
            case 1113200646: {
                return 8;
            }
            case 1115297793: {
                return 9;
            }
            case 1113200654: {
                return 10;
            }
            case 1113200642: {
                return 11;
            }
            case 1650071565: {
                return 12;
            }
            case 1113200647: {
                return 13;
            }
            case 1113200649: {
                return 14;
            }
            case 1113200650: {
                return 15;
            }
            case 1113198595: {
                return 16;
            }
            case 135175: {
                return 17;
            }
            case 135198: {
                return 18;
            }
            case 1113198597: {
                return 19;
            }
            case 1113198596: {
                return 20;
            }
            case 135192: {
                return 21;
            }
            case 135174: {
                return 23;
            }
            case 135176: {
                return 22;
            }
            case 135180: {
                return 24;
            }
            case 135402505: {
                return 25;
            }
            case 135182: {
                return 26;
            }
            case 0x121012: {
                return 27;
            }
            case 135188: {
                return 28;
            }
            case 135190: {
                return 29;
            }
            case 537022465: {
                return 30;
            }
            case 1611272194: {
                return 31;
            }
            case 1679429641: {
                return 32;
            }
            case 1614417948: {
                return 33;
            }
            case 544771: {
                return 34;
            }
            case 1611272202: {
                return 35;
            }
        }
        return -1;
    }

    public static final String getShapeClassName(int n, boolean bl) {
        if (n < 0) {
            return shapeClassBases[~n];
        }
        return "org.jmol." + (bl ? "render" : "shape") + (n >= 9 && n < 16 ? "bio." : (n >= 16 && n < 23 ? "special." : (n >= 24 && n < 29 ? "surface." : (n == 23 ? "cgo." : ".")))) + shapeClassBases[n];
    }

    public static final int getShapeVisibilityFlag(int n) {
        return 4 << n;
    }

    public static int getOffset(int n, int n2) {
        n = Math.min(Math.max(n, -127), 127);
        n2 = Math.min(Math.max(n2, -127), 127);
        return (n & 0xFF) << 8 | n2 & 0xFF;
    }

    public static int getXOffset(int n) {
        switch (n) {
            case 0: {
                return 4;
            }
            case 32767: {
                return 0;
            }
        }
        return (int)((long)n << 48 >> 56);
    }

    public static int getYOffset(int n) {
        switch (n) {
            case 0: {
                return -4;
            }
            case 32767: {
                return 0;
            }
        }
        return -((int)((long)n << 56 >> 56));
    }

    public static String getAlignmentName(int n) {
        return hAlignNames[n & 3];
    }

    public static String getPointer(int n) {
        return (n & 1) == 0 ? "" : ((n & 2) > 0 ? "background" : "on");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String string = null;
        String string2 = null;
        BufferedInputStream bufferedInputStream = null;
        InputStream inputStream = null;
        try {
            inputStream = JC.class.getClassLoader().getResourceAsStream("org/jmol/viewer/Jmol.properties");
            bufferedInputStream = new BufferedInputStream(inputStream);
            Properties properties = new Properties();
            properties.load(bufferedInputStream);
            string = PT.trimQuotes(properties.getProperty("___JmolVersion", string));
            string2 = PT.trimQuotes(properties.getProperty("___JmolDate", string2));
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        if (string2 != null) {
            string2 = string2.substring(7, 24);
        }
        version = string != null ? string : "(Unknown version)";
        date = string2 != null ? string2 : "(Unknown date)";
        center = V3.new3(0.0f, 0.0f, 0.0f);
        axisX = V3.new3(1.0f, 0.0f, 0.0f);
        axisY = V3.new3(0.0f, 1.0f, 0.0f);
        axisZ = V3.new3(0.0f, 0.0f, 1.0f);
        axisNX = V3.new3(-1.0f, 0.0f, 0.0f);
        axisNY = V3.new3(0.0f, -1.0f, 0.0f);
        axisNZ = V3.new3(0.0f, 0.0f, -1.0f);
        unitAxisVectors = new V3[]{axisX, axisY, axisZ, axisNX, axisNY, axisNZ};
        altArgbsCpk = new int[]{-60269, -4217178, -208, -11069553, -64, -96, -2565928, -11513776, -12566464, -15708080};
        argbsAmino = new int[]{-4284306, -3618616, -15443201, -16720676, -1701366, -1645056, -16720676, -1701366, -1315861, -8224046, -15760881, -15760881, -15443201, -1645056, -13487446, -2320766, -354816, -354816, -4957516, -13487446, -15760881, -38476, -38476, -4284306};
        argbsChainAtom = new int[]{-1, -4140801, -5177424, -16184, -128, -16129, -5181200, -12176, -1015680, -663885, -16728065, -3318692, -10039894, -6632142, -1146130, -16724271, -16711809, -12799119, -16777077, -4343957, -16751616, -8388608, -8355840, -8388480, -16744320, -4684277, -5103070};
        argbsChainHetero = new int[]{-1, -7298865, -8335464, -3174224, -3158160, -3174193, -8339264, -3170208, -4173712, -3821949, -16734257, -4895668, -11094638, -7686870, -4296002, -16730463, -16724113, -13329567, -16777029, -5922981, -16739328, -5242880, -5197824, -5242704, -16731984, -1526253, -4050382};
        argbsFormalCharge = new int[]{-65536, -49088, -32640, -16192, -1, -2565889, -4934401, -7302913, -9671425, -12039937, -14408449, -16776961};
        argbsRwbScale = new int[]{-65536, -61424, -57312, -53200, -49088, -44976, -40864, -36752, -32640, -28528, -24416, -20304, -16192, -12080, -7968, -1, -2039553, -3092225, -4144897, -5197569, -6250241, -7302913, -8355585, -9408257, -10460929, -11513601, -12566273, -13618945, -14671617, -15724289, -16776961};
        FORMAL_CHARGE_COLIX_RED = Elements.elementSymbols.length;
        PARTIAL_CHARGE_COLIX_RED = Elements.elementSymbols.length + argbsFormalCharge.length;
        PARTIAL_CHARGE_RANGE_SIZE = argbsRwbScale.length;
        argbsRoygbScale = new int[]{-65536, -57344, -49152, -40960, Short.MIN_VALUE, -24576, -16384, -8192, -4096, -256, -987136, -2031872, -4129024, -6226176, -8323328, -10420480, -12517632, -14614784, -16711936, -16711904, -16711872, -16711840, -16711808, -16711776, -16711744, -16711712, -16711681, -16719617, -16727809, -16736001, -16744193, -16752385, -16760577, -16768769, -16776961};
        specialAtomNames = new String[]{null, "N", "CA", "C", "O", "O1", "O5'", "C5'", "C4'", "C3'", "O3'", "C2'", "C1'", "P", "OD1", "OD2", "OE1", "OE2", "SG", null, null, null, null, null, null, null, null, null, null, null, null, null, "N1", "C2", "N3", "C4", "C5", "C6", "O2", "N7", "C8", "N9", "N4", "N2", "N6", "C5M", "O6", "O4", "S4", "C7", "H1", "H2", "H3", null, null, null, null, null, null, null, null, null, null, null, "OXT", "H", "1H", "2H", "3H", "HA", "1HA", "2HA", "H5T", "O5T", "O1P", "OP1", "O2P", "OP2", "O4'", "O2'", "1H5'", "2H5'", "H4'", "H3'", "1H2'", "2H2'", "2HO'", "H1'", "H3T", "HO3'", "HO5'", "HA2", "HA3", "HA2", "H5'", "H5''", "H2'", "H2''", "HO2'", "O3P", "OP3"};
        ATOMID_MAX = specialAtomNames.length;
        predefinedGroup3Names = new String[]{"", "ALA", "ARG", "ASN", "ASP", "CYS", "GLN", "GLU", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL", "ASX", "GLX", "UNK", "G", "C", "A", "T", "U", "I", "DG", "DC", "DA", "DT", "DU", "DI", "+G", "+C", "+A", "+T", "+U", "+I", "HOH", "DOD", "WAT", "UREA", "PO4", "SO4", "UNL"};
        pdbBondInfo = new String[]{"", "N N CA HA C O CB HB?", "N N CA HA C O CB HB2@HB3 CG HG2@HG3 CD D NE HE CZ NH1 NH1 HH11@HH12 NH2 HH21@HH22", "N N CA HA C O CB B CG OD1 ND2 HD21@HD22", "N N CA HA C O CB B CG OD1", "N N CA HA C O CB B SG HG", "N N CA HA C O CB B CG G CD OE1 NE2 HE21@HE22", "N N CA HA C O CB B CG G CD OE1", "N N CA HA2@HA3 C O", "N N CA HA C O CB B CG CD2 ND1 CE1 ND1 HD1 CD2 HD2 CE1 HE1 NE2 HE2", "N N CA HA C O CB HB CG1 HG12@HG13 CG2 HG2? CD1 HD1?", "N N CA HA C O CB HB2@HB3 CG HG CD1 HD1? CD2 HD2?", "N N CA HA C O CB B CG G CD HD2@HD3 CE HE3@HE2 NZ HZ?", "N N CA HA C O CB HB2@HB3 CG HG2@HG3 CE HE?", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 CD2 HD2 CE1 CZ CE1 HE1 CE2 HE2 CZ HZ", "N H CA HA C O CB B CG G CD HD2@HD3", "N N CA HA C O CB B OG HG", "N N CA HA C O CB HB OG1 HG1 CG2 HG2?", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 NE1 HE1 CE3 CZ3 CE3 HE3 CZ2 CH2 CZ2 HZ2 CZ3 HZ3 CH2 HH2", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 CD2 HD2 CE1 CZ CE1 HE1 CE2 HE2 OH HH", "N N CA HA C O CB HB CG1 HG1? CG2 HG2?", "CA HA C O CB HB2@HB1 C H", "CA HA C O CB HB1 CB HB2 CG HG1 CG HG2", "", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 N2 H21@H22 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C2 O2 N3 C4 N4 H41@H42 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 N1 N6 H61@H62 C2 N3 C2 H2 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C7 H7? C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 C2 H2 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 N2 H21@H22 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 C4 N4 H41@H42 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 N1 N6 H61@H62 C2 N3 C2 H2 O3' HO3' O5' HO5'", "P OP1 C5' H5'@H5'' C4' H4' C3' H3' C2' H2'@H2'' C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C7 H7? C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2'@H2'' C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 C2 H2 O3' HO3' O5' HO5'"};
        pdbHydrogenCount = new int[]{0, 6, 16, 7, 6, 6, 9, 8, 4, 9, 12, 12, 14, 10, 10, 8, 6, 8, 11, 10, 10, 3, 5, 0, 13, 13, 13, -1, 12, 12, 13, 13, 13, 14, 12, 12};
        argbsShapely = new int[]{-65281, -16777092, -33680, -7536756, -6291390, -144, -46004, -10092544, -1, -9408257, -16757760, -12231099, -12105800, -11318190, -4677566, -11382190, -36798, -4699136, -11581952, -7573428, -29441, -65281, -65281, -65281, -36752, -29621, -6250241, -6226016, -32640, -8323073, -36752, -29621, -6250241, -6226016, -32640, -8323073, -36752, -29621, -6250241, -6226016, -32640, -8323073};
        predefinedGroup1Names = new char[]{'\u0000', 'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V', 'A', 'G', '?', 'G', 'C', 'A', 'T', 'U', 'I', 'G', 'C', 'A', 'T', 'U', 'I', 'G', 'C', 'A', 'T', 'U', 'I', 'I'};
        predefinedVariable = new String[]{"@_1H _H & !(_2H,_3H)", "@_12C _C & !(_13C,_14C)", "@_14N _N & !(_15N)", "@water _g>=42 & _g<45, oxygen & connected(2) & connected(2, hydrogen), (hydrogen) & connected(oxygen & connected(2) & connected(2, hydrogen))", "@solvent water, (_g>=45 & _g<48)", "@ligand _g=0|!(_g<46,protein,nucleic,water)", "@turn structure=1", "@sheet structure=2", "@helix structure=3", "@helix310 substructure=7", "@helixalpha substructure=8", "@helixpi substructure=9", "@bonded bondcount>0"};
        predefinedStatic = new String[]{"@amino _g>0 & _g<=23", "@acidic asp,glu", "@basic arg,his,lys", "@charged acidic,basic", "@negative acidic", "@positive basic", "@neutral amino&!(acidic,basic)", "@polar amino&!hydrophobic", "@cyclic his,phe,pro,trp,tyr", "@acyclic amino&!cyclic", "@aliphatic ala,gly,ile,leu,val", "@aromatic his,phe,trp,tyr", "@cystine within(group, (cys.sg or cyx.sg) and connected(cys.sg or cyx.sg))", "@buried ala,cys,ile,leu,met,phe,trp,val", "@surface amino&!buried", "@hydrophobic ala,gly,ile,leu,met,phe,pro,trp,tyr,val", "@mainchain backbone", "@small ala,gly,ser", "@medium asn,asp,cys,pro,thr,val", "@large arg,glu,gln,his,ile,leu,lys,met,phe,trp,tyr", "@c nucleic & ([C] or [DC] or within(group,_a=42))", "@g nucleic & ([G] or [DG] or within(group,_a=43))", "@cg c,g", "@a nucleic & ([A] or [DA] or within(group,_a=44))", "@t nucleic & ([T] or [DT] or within(group,_a=45 | _a=49))", "@at a,t", "@i nucleic & ([I] or [DI] or within(group,_a=46) & !g)", "@u nucleic & ([U] or [DU] or within(group,_a=47) & !t)", "@tu nucleic & within(group,_a=48)", "@ions _g>=46&_g<48", "@alpha _a=2", "@backbone protein&(_a>=1&_a<6|_a>=64&_a<72)|nucleic&(_a>=6&_a<14|_a>=72)", "@spine protein&_a>=1&_a<4|nucleic&_a>=6&_a<14&_a!=12", "@sidechain (protein,nucleic) & !backbone", "@base nucleic & !backbone", "@dynamic_flatring search('[a]')"};
        databases = new String[]{"ligand", "http://www.rcsb.org/pdb/files/ligand/%FILE.cif", "mp", "http://www.materialsproject.org/materials/%FILE/cif", "nci", "http://cactus.nci.nih.gov/chemical/structure/%FILE", "nmr", "http://www.nmrdb.org/predictor?POST?molfile=", "nmrdb", "http://www.nmrdb.org/service/predictor?POST?molfile=", "pdb", "http://www.rcsb.org/pdb/files/%FILE.pdb.gz", "pubchem", "http://pubchem.ncbi.nlm.nih.gov/rest/pug/compound/%FILE/SDF?record_type=3d"};
        shapeClassBases = new String[]{"Balls", "Sticks", "Hsticks", "Sssticks", "Struts", "Labels", "Measures", "Stars", "Halos", "Backbone", "Trace", "Cartoon", "Strands", "MeshRibbon", "Ribbons", "Rockets", "Dots", "Dipoles", "Vectors", "GeoSurface", "Ellipsoids", "Polyhedra", "Draw", "CGO", "Isosurface", "Contact", "LcaoCartoon", "MolecularOrbital", "Pmesh", "Plot3D", "Echo", "Axes", "Bbcage", "Uccage", "Hover", "Frank"};
        if (argbsFormalCharge.length != 12) {
            Logger.error("formal charge color table length");
            throw new NullPointerException();
        }
        if (shapeClassBases.length != 36) {
            Logger.error("shapeClassBases wrong length");
            throw new NullPointerException();
        }
        if (argbsAmino.length != 24) {
            Logger.error("argbsAmino wrong length");
            throw new NullPointerException();
        }
        if (argbsShapely.length != 42) {
            Logger.error("argbsShapely wrong length");
            throw new NullPointerException();
        }
        if (argbsChainHetero.length != argbsChainAtom.length) {
            Logger.error("argbsChainHetero wrong length");
            throw new NullPointerException();
        }
        if (shapeClassBases.length != 36) {
            Logger.error("the shapeClassBases array has the wrong length");
            throw new NullPointerException();
        }
        hAlignNames = new String[]{"", "left", "center", "right", ""};
        vAlignNames = new String[]{"xy", "top", "bottom", "middle"};
    }
}

