/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Map;
import javajs.util.AU;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.constant.EnumStructure;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Logger;

public abstract class ProteinStructure {
    EnumStructure type;
    EnumStructure subtype;
    String structureID;
    int strucNo;
    int serialID;
    int strandCount;
    protected AlphaPolymer apolymer;
    protected int monomerIndexFirst;
    protected int monomerCount;
    protected P3 axisA;
    protected P3 axisB;
    protected V3 axisUnitVector;
    protected final V3 vectorProjection = new V3();
    private static int globalStrucNo = 1000;
    private int monomerIndexLast;
    private P3[] segments;

    protected void setupPS(AlphaPolymer alphaPolymer, EnumStructure enumStructure, int n, int n2) {
        this.strucNo = ++globalStrucNo;
        this.apolymer = alphaPolymer;
        this.type = enumStructure;
        this.monomerIndexFirst = n;
        this.addMonomer(n + n2 - 1);
        if (Logger.debugging) {
            Logger.debug("Creating ProteinStructure " + this.strucNo + " " + enumStructure.getBioStructureTypeName(false) + " from " + this.monomerIndexFirst + " through " + this.monomerIndexLast + " in polymer " + alphaPolymer);
        }
    }

    void addMonomer(int n) {
        this.monomerIndexFirst = Math.min(this.monomerIndexFirst, n);
        this.monomerIndexLast = Math.max(this.monomerIndexLast, n);
        this.monomerCount = this.monomerIndexLast - this.monomerIndexFirst + 1;
    }

    int removeMonomer(int n) {
        if (n > this.monomerIndexLast || n < this.monomerIndexFirst) {
            return 0;
        }
        int n2 = this.monomerIndexLast - n;
        this.monomerIndexLast = Math.max(this.monomerIndexFirst, n) - 1;
        this.monomerCount = this.monomerIndexLast - this.monomerIndexFirst + 1;
        return n2;
    }

    public void calcAxis() {
    }

    void calcSegments() {
        if (this.segments != null) {
            return;
        }
        this.calcAxis();
        this.segments = new P3[this.monomerCount + 1];
        this.segments[this.monomerCount] = this.axisB;
        this.segments[0] = this.axisA;
        V3 v3 = V3.newV(this.axisUnitVector);
        v3.scale(this.axisB.distance(this.axisA) / (float)this.monomerCount);
        for (int i = 1; i < this.monomerCount; ++i) {
            P3 p3 = this.segments[i] = new P3();
            p3.add2(this.segments[i - 1], v3);
        }
    }

    boolean lowerNeighborIsHelixOrSheet() {
        if (this.monomerIndexFirst == 0) {
            return false;
        }
        return this.apolymer.monomers[this.monomerIndexFirst - 1].isHelix() || this.apolymer.monomers[this.monomerIndexFirst - 1].isSheet();
    }

    boolean upperNeighborIsHelixOrSheet() {
        int n = this.monomerIndexFirst + this.monomerCount;
        if (n == this.apolymer.monomerCount) {
            return false;
        }
        return this.apolymer.monomers[n].isHelix() || this.apolymer.monomers[n].isSheet();
    }

    public int getMonomerCount() {
        return this.monomerCount;
    }

    public boolean isWithin(int n) {
        return n > this.monomerIndexFirst && n < this.monomerIndexLast;
    }

    public int getMonomerIndex() {
        return this.monomerIndexFirst;
    }

    public int getIndex(Monomer monomer) {
        Monomer[] monomerArray = this.apolymer.monomers;
        int n = this.monomerCount;
        while (--n >= 0 && monomerArray[this.monomerIndexFirst + n] != monomer) {
        }
        return n;
    }

    public P3[] getSegments() {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments;
    }

    public P3 getAxisStartPoint() {
        this.calcAxis();
        return this.axisA;
    }

    public P3 getAxisEndPoint() {
        this.calcAxis();
        return this.axisB;
    }

    P3 getStructureMidPoint(int n) {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments[n];
    }

    public void getInfo(Map<String, Object> map) {
        map.put("type", this.type.getBioStructureTypeName(false));
        int[] nArray = this.apolymer.getLeadAtomIndices();
        int[] nArray2 = AU.arrayCopyRangeI(nArray, this.monomerIndexFirst, this.monomerIndexFirst + this.monomerCount);
        map.put("leadAtomIndices", nArray2);
        this.calcAxis();
        if (this.axisA == null) {
            return;
        }
        map.put("axisA", this.axisA);
        map.put("axisB", this.axisB);
        map.put("axisUnitVector", this.axisUnitVector);
    }

    void resetAxes() {
        this.axisA = null;
        this.segments = null;
    }
}

