/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.P3;
import javajs.util.V3;
import org.jmol.constant.EnumStructure;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Measure;

public class Helix
extends ProteinStructure {
    Helix(AlphaPolymer alphaPolymer, int n, int n2, EnumStructure enumStructure) {
        this.setupPS(alphaPolymer, EnumStructure.HELIX, n, n2);
        this.subtype = enumStructure;
    }

    @Override
    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        P3[] p3Array = new P3[this.monomerCount + 1];
        for (int i = 0; i <= this.monomerCount; ++i) {
            p3Array[i] = new P3();
            this.apolymer.getLeadMidPoint(this.monomerIndexFirst + i, p3Array[i]);
        }
        this.axisA = new P3();
        this.axisUnitVector = new V3();
        Measure.calcBestAxisThroughPoints(p3Array, this.axisA, this.axisUnitVector, this.vectorProjection, 4);
        this.axisB = P3.newP(p3Array[this.monomerCount]);
        Measure.projectOntoAxis(this.axisB, this.axisA, this.axisUnitVector, this.vectorProjection);
    }
}

